/*
 * Decompiled with CFR 0.152.
 */
package com.yungouos.pay.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaySignUtil {
    public static String createSign(Map<String, Object> params, String partnerKey) {
        params.remove("sign");
        String stringA = PaySignUtil.packageSign(params, false);
        String stringSignTemp = stringA + "&key=" + partnerKey;
        return SecureUtil.md5(stringSignTemp).toUpperCase();
    }

    public static String packageSign(Map<String, Object> params, boolean urlEncoder) {
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>(params);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Object> param : sortedParams.entrySet()) {
            String value = String.valueOf(param.getValue());
            if (StrUtil.isBlank(value)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(param.getKey()).append("=");
            if (urlEncoder) {
                try {
                    value = PaySignUtil.urlEncode(value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static String urlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, "utf-8");
    }

    public static boolean checkNotifySign(HttpServletRequest request, String partnerKey) throws Exception {
        try {
            if (request == null) {
                throw new Exception("request\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String sign = request.getParameter("sign");
            if (StrUtil.isBlank(sign)) {
                throw new Exception("request\u4e2d\u672a\u83b7\u53d6\u5230sign");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            String code = request.getParameter("code");
            String orderNo = request.getParameter("orderNo");
            String outTradeNo = request.getParameter("outTradeNo");
            String payNo = request.getParameter("payNo");
            String money = request.getParameter("money");
            String mchId = request.getParameter("mchId");
            params.put("code", code);
            params.put("orderNo", orderNo);
            params.put("outTradeNo", outTradeNo);
            params.put("payNo", payNo);
            params.put("money", money);
            params.put("mchId", mchId);
            String reSign = PaySignUtil.createSign(params, partnerKey);
            if (sign.equals(reSign)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return false;
    }

    public static boolean checkRefundNotifySign(HttpServletRequest request, String partnerKey) throws Exception {
        try {
            if (request == null) {
                throw new Exception("request\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String sign = request.getParameter("sign");
            if (StrUtil.isBlank(sign)) {
                throw new Exception("request\u4e2d\u672a\u83b7\u53d6\u5230sign");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            String code = request.getParameter("code");
            String refundNo = request.getParameter("refundNo");
            String orderNo = request.getParameter("orderNo");
            String outTradeNo = request.getParameter("outTradeNo");
            String payNo = request.getParameter("payNo");
            String mchId = request.getParameter("mchId");
            String payName = request.getParameter("payName");
            String refundMoney = request.getParameter("refundMoney");
            String channel = request.getParameter("channel");
            String refundTime = request.getParameter("refundTime");
            String payRefundNo = request.getParameter("payRefundNo");
            String applyTime = request.getParameter("applyTime");
            params.put("code", code);
            params.put("refundNo", refundNo);
            params.put("orderNo", orderNo);
            params.put("outTradeNo", outTradeNo);
            params.put("payNo", payNo);
            params.put("mchId", mchId);
            params.put("payName", payName);
            params.put("refundMoney", refundMoney);
            params.put("channel", channel);
            params.put("refundTime", refundTime);
            params.put("payRefundNo", payRefundNo);
            params.put("applyTime", applyTime);
            String reSign = PaySignUtil.createSign(params, partnerKey);
            if (sign.equals(reSign)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return false;
    }
}

