/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.naturalli.VerbTense;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class QuestionToStatementTranslator {
    private final CoreLabel WORD_MISSING = new CoreLabel(){
        {
            this.setWord("thing");
            this.setValue("thing");
            this.setLemma("thing");
            this.setTag("NN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_MISSING_LOCATION = new CoreLabel(){
        {
            this.setWord("location");
            this.setValue("location");
            this.setLemma("location");
            this.setTag("NNP");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_MISSING_PERSON = new CoreLabel(){
        {
            this.setWord("person");
            this.setValue("person");
            this.setLemma("person");
            this.setTag("NNP");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_MISSING_TIME = new CoreLabel(){
        {
            this.setWord("time");
            this.setValue("time");
            this.setLemma("time");
            this.setTag("NN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_ADJECTIVE = new CoreLabel(){
        {
            this.setWord("adjective");
            this.setValue("adjective");
            this.setLemma("adjective");
            this.setTag("JJ");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_WAY = new CoreLabel(){
        {
            this.setWord("way");
            this.setValue("way");
            this.setLemma("way");
            this.setTag("RB");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_FROM = new CoreLabel(){
        {
            this.setWord("from");
            this.setValue("from");
            this.setLemma("from");
            this.setTag("IN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
        }
    };
    private final CoreLabel WORD_AT = new CoreLabel(){
        {
            this.setWord("at");
            this.setValue("at");
            this.setLemma("at");
            this.setTag("IN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
        }
    };
    private final CoreLabel WORD_IN = new CoreLabel(){
        {
            this.setWord("in");
            this.setValue("in");
            this.setLemma("in");
            this.setTag("IN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
        }
    };
    private final CoreLabel WORD_TO = new CoreLabel(){
        {
            this.setWord("to");
            this.setValue("to");
            this.setLemma("to");
            this.setTag("TO");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.setBefore(" ");
            this.setAfter(" ");
        }
    };
    private final Set<String> fromNotAtDict = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("funding");
            this.add("oil");
        }
    });
    private final TokenSequencePattern triggerWhatIs = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [tag:/N.*/]+)? (?$be [{lemma:be}] )(?: /the/ (?$answer_type [word:/name/]) [tag:/[PW].*/])? (?$statement_body []+?) (?$prep_num [!{tag:IN}] [tag:CD] )? (?$suffix [tag:/[RI].*/] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhNNWill = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [!{lemma:be} & !{pos:\"PRP$\"} & !{pos:MD}]+) (?$will [{pos:MD}]) (?$subj [{pos:/NN.?.?/} | {pos:PRP}]+) (?$statement_body [!{pos:IN}]+) (?$pp_prefix [{pos:IN}]*) (?$pp [{pos:IN}]) (?$pp_body []*) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhNNIs = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [!{lemma:be} & !{pos:\"PRP$\"} | {word:i}]+) (?$be [{lemma:be}] [{tag:/[VRIJ].*/}] ) (?$statement_body []+?) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhNNHave = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [!{tag:/V.*/}]+) (?$have [{lemma:have} | {lemma:do} | {lemma:be}] ) (?$pre_verb [!{tag:/V.*/}]+ ) (?$verb [{tag:/V.*/}] [{tag:IN}]? ) (?$post_verb []+ )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhNNHaveNN = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [tag:/N.*/]+) (?$have [{lemma:have}] ) (?$statement_body [!{tag:/V.*/}]+?) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhatIsThere = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [tag:/N.*/]+)? (?$be [{lemma:be}] )(?$there [{lemma:there; tag:RB}] ) (?$adjmod [{tag:/[JN].*/}] )? (?$to_verb [{tag:TO}] [{tag:/V.*/}] )? (?$statement_body [{tag:IN}] []+?) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhereDo = TokenSequencePattern.compile("[{lemma:where; tag:/W.*/}] (?$do [ {lemma:/do/} ]) (?$statement_body []+?) (?$at [tag:/[IT].*/] )? (?$loc [tag:/N.*/] )*? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhereIs = TokenSequencePattern.compile("[{lemma:where; tag:/W.*/}] (?$be [ {lemma:/be/} ]) (?$initial_verb [tag:/[VJ].*/] )? (?$subject [{tag:/NN.?.?/}]+ ((in|at|of) [{tag:/NN.?.?/}]+)* )? (?$statement_body []*?)? (?$ignored [lemma:locate] [tag:IN] [word:a]? [word:map]? )? (?$final_verb [tag:/[VJ].*/] )? (?$at [tag:IN] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhoIs = TokenSequencePattern.compile("[{lemma:who; tag:/W.*/}] (?$be [ {lemma:/be/} ] ) (?$prep [ {tag:/IN|V.*/} ] )? (?$statement_body []+?) (?$final_verb [tag:/V.*/] [tag:/[IRT].*/] )? (?$final_verb [tag:VBG] )? (?$now [tag:RB] )? (?$prep_num [!{tag:IN}] [tag:CD] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhoDid = TokenSequencePattern.compile("[{lemma:who; tag:/W.*/}] (?$do [ {lemma:/do/} ] ) (?$statement_body []+?) (?$now [tag:RB] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhatDo = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$do [ {lemma:/do/} ]) (?$pre_do [ !{lemma:do} & !{tag:IN} ]+) (?$mid_do [ {lemma:do} ] )? (?$in [ {tag:IN} ] )? (?$post_do []+ )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhenDo = TokenSequencePattern.compile("[{lemma:when; tag:/W.*/}] (?$do [ {lemma:/do/} ]) (?$statement_body []+?) (?$in [tag:/[IT].*/] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhatHave = TokenSequencePattern.compile("[{lemma:what; tag:/W.*/}] (?$have [ {lemma:/have/} ]) (?$pre_verb [!{tag:/V.*/}]+ )? (?$verb [tag:/V.*/] [tag:IN]? ) (?$post_verb []+ )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerHow = TokenSequencePattern.compile("([{lemma:/[Hh]ow/; tag:/W.*/}] | /[Ww]hat/ [{lemma:be}] /ways?/ (?$prp0 [{tag:/PRP.?/} | {word:i}]) ) ((?$do [ {lemma:/do/} | {lemma:can}]) | (?$jj [ {pos:JJ} ]{0,3}) (?$be [ {lemma:be} ])) (?$prp1 [{tag:/PRP.?/} | {word:i}])? (?$statement_body []+?) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerHowMuchDo = TokenSequencePattern.compile("[{lemma:/[Hh]ow/; tag:/W.*/}] (much | many) [{pos:NN}]{0,10} ((?$do [ {lemma:/do/} | {lemma:can}]) | (?$jj [ {pos:JJ} ]) (?$be [ {lemma:be} ])) (?$prefix [!{lemma:to}]{1,25}) (?$connective [{lemma:to}])? (?$suffix [!{lemma:to}]{1,25}) (?$punct [word:/[?\\.!]/])");

    private List<CoreLabel> processWhatIs(TokenSequenceMatcher matcher) {
        int k;
        int i;
        List prepNum;
        LinkedList<Object> body = new LinkedList(matcher.groupNodes("$statement_body"));
        List<CoreLabel> be = matcher.groupNodes("$be");
        List suffix = matcher.groupNodes("$suffix");
        boolean addedBe = false;
        boolean addedSuffix = false;
        if (body.size() > 1 && !"PRP".equals(((CoreLabel)body.get(0)).tag())) {
            for (int i2 = 2; i2 < body.size(); ++i2) {
                CoreLabel tokI = (CoreLabel)body.get(i2);
                if (tokI.tag() == null || !(tokI.tag().startsWith("V") && !tokI.tag().equals("VBD") && !"be".equals(((CoreLabel)body.get(i2 - 1)).lemma()) || tokI.tag().startsWith("J") && suffix != null || tokI.tag().startsWith("D") && suffix != null) && (!tokI.tag().startsWith("R") || suffix == null)) continue;
                body.add(i2, be.get(0));
                ++i2;
                if (suffix != null) {
                    while (i2 < body.size() && ((CoreLabel)body.get(i2)).tag() != null && (((CoreLabel)body.get(i2)).tag().startsWith("J") || ((CoreLabel)body.get(i2)).tag().startsWith("V") || ((CoreLabel)body.get(i2)).tag().startsWith("R") || ((CoreLabel)body.get(i2)).tag().startsWith("N") || ((CoreLabel)body.get(i2)).tag().startsWith("D")) && !((CoreLabel)body.get(i2)).tag().equals("VBG")) {
                        ++i2;
                    }
                    body.add(i2, suffix.get(0));
                    addedSuffix = true;
                }
                addedBe = true;
                break;
            }
        }
        if ((prepNum = matcher.groupNodes("$prep_num")) != null) {
            body.add(prepNum.get(0));
            body.add(this.WORD_IN);
            body.add(prepNum.get(1));
        }
        if (!addedSuffix && suffix != null) {
            body.addAll(suffix);
        }
        if (!addedBe) {
            if (body.size() > 1 && "PRP".equals(((CoreLabel)body.get(0)).tag())) {
                body.add(1, be.get(0));
            } else {
                body.addAll(be);
            }
        }
        if (body.size() > 1 && "do".equals(((CoreLabel)body.get(body.size() - 1)).word())) {
            body = new LinkedList(body.subList(0, body.size() - 1));
        }
        List objType = matcher.groupNodes("$answer_type");
        for (i = body.size() - 1; i >= 1 && ((CoreLabel)body.get(i)).tag() != null && (((CoreLabel)body.get(i)).tag().startsWith("N") || ((CoreLabel)body.get(i)).tag().startsWith("J")); --i) {
        }
        if (objType == null || objType.isEmpty() || objType.size() == 1 && ((CoreLabel)objType.get(0)).word().equals("name")) {
            if (i < body.size() - 1 && ((CoreLabel)body.get(i)).tag() != null && ((CoreLabel)body.get(i)).tag().startsWith("IN")) {
                body.add(i, this.WORD_MISSING);
            } else if (body.size() >= 2 && ((CoreLabel)body.get(body.size() - 2)).tag() != null && ((CoreLabel)body.get(body.size() - 2)).tag().startsWith("N") && !((CoreLabel)body.get(body.size() - 1)).tag().equals("IN")) {
                if (!addedBe) {
                    Collections.reverse(be);
                    be.forEach(body::addFirst);
                }
                body.addFirst(this.WORD_MISSING);
                Iterator beIter = be.iterator();
                if (beIter.hasNext() && body.getLast() == beIter.next()) {
                    body.removeLast();
                }
            } else {
                body.addLast(this.WORD_MISSING);
            }
        } else {
            for (CoreLabel obj : objType) {
                obj.set(UnknownTokenMarker.class, true);
            }
            body.addAll(objType);
        }
        for (k = 1; k < body.size(); ++k) {
            if (!"DT".equals(((CoreLabel)body.get(k - 1)).tag()) || !"be".equals(((CoreLabel)body.get(k)).lemma())) continue;
            Collections.swap(body, k - 1, k);
        }
        if (body.stream().noneMatch(x -> x.tag() != null && x.tag().startsWith("V") && (be.isEmpty() || x != be.get(0)))) {
            for (k = 1; k < body.size(); ++k) {
                if (!"IN".equals(((CoreLabel)body.get(k - 1)).tag()) || !"be".equals(((CoreLabel)body.get(k)).lemma())) continue;
                Collections.swap(body, k - 1, k);
            }
        }
        return body;
    }

    private List<CoreLabel> processWhNNWill(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$subj");
        sentence.addAll(matcher.groupNodes("$will"));
        sentence.addAll(matcher.groupNodes("$statement_body"));
        List answerType = matcher.groupNodes("$answer_type");
        for (CoreLabel lbl : answerType) {
            lbl.set(UnknownTokenMarker.class, true);
        }
        sentence.addAll(matcher.groupNodes("$pp_prefix"));
        sentence.addAll(answerType);
        sentence.addAll(matcher.groupNodes("$pp"));
        sentence.addAll(matcher.groupNodes("$pp_body"));
        return sentence;
    }

    private List<CoreLabel> processWhNNIs(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$answer_type");
        for (CoreLabel lbl : sentence) {
            lbl.set(UnknownTokenMarker.class, true);
        }
        sentence.addAll(matcher.groupNodes("$be"));
        sentence.addAll(matcher.groupNodes("$statement_body"));
        return sentence;
    }

    private List<CoreLabel> processWhNNHaveIs(TokenSequenceMatcher matcher) {
        List answer;
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>(matcher.groupNodes("$pre_verb"));
        List have = matcher.groupNodes("$have");
        if (have != null && have.size() > 0 && ((CoreLabel)have.get(0)).lemma() != null && (((CoreLabel)have.get(0)).lemma().equalsIgnoreCase("have") || ((CoreLabel)have.get(0)).lemma().equalsIgnoreCase("be"))) {
            sentence.addAll(matcher.groupNodes("$have"));
        }
        if ((answer = matcher.groupNodes("$answer_type")) != null) {
            for (CoreLabel lbl : answer) {
                lbl.set(UnknownTokenMarker.class, true);
            }
        }
        List verb = matcher.groupNodes("$verb");
        List post = matcher.groupNodes("$post_verb");
        if (verb.size() < 2 || post == null || post.size() == 0 || ((CoreLabel)post.get(0)).tag() == null || ((CoreLabel)post.get(0)).tag().equals("CD")) {
            sentence.addAll(verb);
            if (answer == null) {
                sentence.add(this.WORD_MISSING);
            } else {
                sentence.addAll(answer);
            }
        } else {
            sentence.add((CoreLabel)verb.get(0));
            if (answer == null) {
                sentence.add(this.WORD_MISSING);
            } else {
                sentence.addAll(answer);
            }
            sentence.addAll(verb.subList(1, verb.size()));
        }
        if (post != null) {
            if (post.size() == 1 && ((CoreLabel)post.get(0)).tag() != null && ((CoreLabel)post.get(0)).tag().equals("CD")) {
                sentence.add(this.WORD_IN);
            }
            sentence.addAll(post);
        }
        return sentence;
    }

    private List<CoreLabel> processWhNNHaveNN(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$answer_type");
        for (CoreLabel lbl : sentence) {
            lbl.set(UnknownTokenMarker.class, true);
        }
        sentence.addAll(matcher.groupNodes("$have"));
        sentence.addAll(matcher.groupNodes("$statement_body"));
        return sentence;
    }

    private List<CoreLabel> processWhatIsThere(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$there");
        sentence.addAll(matcher.groupNodes("$be"));
        List optSpan = matcher.groupNodes("$adjmod");
        if (optSpan != null) {
            sentence.addAll(optSpan);
        }
        sentence.add(this.WORD_MISSING);
        optSpan = matcher.groupNodes("$to_verb");
        if (optSpan != null) {
            sentence.addAll(optSpan);
        }
        sentence.addAll(matcher.groupNodes("$statement_body"));
        return sentence;
    }

    private List<CoreLabel> processWhereDo(TokenSequenceMatcher matcher, List<CoreLabel> question) {
        String questionLemmas;
        List specloc = matcher.groupNodes("$loc");
        CoreLabel wordAt = this.WORD_AT;
        CoreLabel missing = this.WORD_MISSING_LOCATION;
        if (specloc != null && this.fromNotAtDict.contains(((CoreLabel)specloc.get(0)).word())) {
            wordAt = this.WORD_FROM;
            missing = this.WORD_MISSING;
        }
        if ((questionLemmas = " " + StringUtils.join(question.stream().map(CoreLabel::lemma), " ") + " ").contains(" go ") && !questionLemmas.contains(" go to ")) {
            wordAt = this.WORD_TO;
        }
        List<CoreLabel> sentence = matcher.groupNodes("$statement_body");
        for (CoreLabel lbl : sentence) {
            if (!"name".equals(lbl.word())) continue;
            missing = this.WORD_MISSING;
        }
        List at = matcher.groupNodes("$at");
        if (at != null && at.size() > 0) {
            sentence.addAll(at);
        } else {
            if (specloc != null) {
                sentence.addAll(specloc);
            }
            sentence.add(wordAt);
        }
        sentence.add(missing);
        return sentence;
    }

    private List<CoreLabel> processWhereIs(TokenSequenceMatcher matcher) {
        List at;
        List verb;
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        List subject = matcher.groupNodes("$subject");
        if (subject != null) {
            sentence.addAll(subject);
        }
        List be = matcher.groupNodes("$be");
        sentence.addAll(be);
        List body = matcher.groupNodes("$statement_body");
        if (body != null) {
            sentence.addAll(body);
        }
        if ((verb = matcher.groupNodes("$final_verb")) != null) {
            sentence.addAll(verb);
        }
        if ((verb = matcher.groupNodes("$initial_verb")) != null) {
            sentence.addAll(verb);
        }
        if ((at = matcher.groupNodes("$at")) != null && at.size() > 0) {
            sentence.addAll(at);
        } else {
            sentence.add(this.WORD_AT);
        }
        sentence.add(this.WORD_MISSING_LOCATION);
        return sentence;
    }

    private List<CoreLabel> processWhoIs(TokenSequenceMatcher matcher) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        List prep = matcher.groupNodes("$prep");
        boolean addedBe = false;
        if (prep != null && !prep.isEmpty()) {
            sentence.add(this.WORD_MISSING_PERSON);
            List be = matcher.groupNodes("$be");
            sentence.addAll(be);
            addedBe = true;
            sentence.addAll(prep);
            sentence.addAll(matcher.groupNodes("$statement_body"));
        } else {
            List verb;
            sentence.addAll(matcher.groupNodes("$statement_body"));
            List prepNum = matcher.groupNodes("$prep_num");
            if (prepNum != null) {
                sentence.add((CoreLabel)prepNum.get(0));
                sentence.add(this.WORD_IN);
                sentence.add((CoreLabel)prepNum.get(1));
            }
            List be = matcher.groupNodes("$be");
            if (sentence.size() > 1 && !((CoreLabel)sentence.get(sentence.size() - 1)).word().equals("be")) {
                sentence.addAll(be);
                addedBe = true;
            }
            if ((verb = matcher.groupNodes("$final_verb")) != null) {
                if (verb.size() > 1 && ((CoreLabel)verb.get(verb.size() - 1)).word().equals("too")) {
                    ((CoreLabel)verb.get(verb.size() - 1)).setWord("to");
                    ((CoreLabel)verb.get(verb.size() - 1)).setValue("to");
                    ((CoreLabel)verb.get(verb.size() - 1)).setLemma("to");
                    ((CoreLabel)verb.get(verb.size() - 1)).setTag("IN");
                }
                sentence.addAll(verb);
            }
            sentence.add(this.WORD_MISSING_PERSON);
        }
        List now = matcher.groupNodes("$now");
        if (now != null) {
            sentence.addAll(now);
        }
        if (!addedBe) {
            for (int i = 0; i < sentence.size(); ++i) {
                if (((CoreLabel)sentence.get(i)).tag() == null || !((CoreLabel)sentence.get(i)).tag().startsWith("V")) continue;
                sentence.add(i, (CoreLabel)matcher.groupNodes("$be").get(0));
                break;
            }
        }
        return sentence;
    }

    private List<CoreLabel> processWhoDid(TokenSequenceMatcher matcher) {
        List now;
        List<CoreLabel> sentence = matcher.groupNodes("$statement_body");
        boolean hasVerb = false;
        for (CoreLabel w : sentence) {
            if (w.tag() == null || !w.tag().startsWith("V")) continue;
            hasVerb = true;
        }
        if (!hasVerb) {
            sentence.add(0, this.WORD_MISSING_PERSON);
            sentence.add(1, (CoreLabel)matcher.groupNodes("$do").get(0));
            return sentence;
        }
        boolean addedPerson = false;
        if (sentence.size() > 0 && ((CoreLabel)sentence.get(sentence.size() - 1)).tag() != null && !sentence.get(sentence.size() - 1).tag().startsWith("I")) {
            for (int i = 0; i < sentence.size() - 1; ++i) {
                if (sentence.get(i).tag() == null || !sentence.get(i).tag().equals("IN") && !sentence.get(i).word().equals("last") && !sentence.get(i).word().equals("next") && !sentence.get(i).word().equals("this")) continue;
                sentence.add(i, this.WORD_MISSING_PERSON);
                addedPerson = true;
                break;
            }
        }
        if (!addedPerson) {
            sentence.add(this.WORD_MISSING_PERSON);
        }
        if ((now = matcher.groupNodes("$now")) != null) {
            sentence.addAll(now);
        }
        return sentence;
    }

    private List<CoreLabel> processWhatDo(TokenSequenceMatcher matcher) {
        List postDo;
        List midIN;
        List<CoreLabel> sentence = matcher.groupNodes("$pre_do");
        List midDo = matcher.groupNodes("$mid_do");
        if (midDo != null) {
            sentence.addAll(matcher.groupNodes("$do"));
        }
        if (matcher.groupNodes("$post_do") != null) {
            sentence.add(this.WORD_MISSING);
        }
        if ((midIN = matcher.groupNodes("$in")) != null) {
            sentence.addAll(midIN);
        }
        if (matcher.groupNodes("$post_do") == null) {
            if (sentence.size() > 1 && "off".equals(((CoreLabel)sentence.get(sentence.size() - 1)).word())) {
                sentence.get(sentence.size() - 1).setWord("of");
                sentence.get(sentence.size() - 1).setValue("of");
                sentence.get(sentence.size() - 1).setLemma("of");
                sentence.get(sentence.size() - 1).setTag("IN");
            }
            sentence.add(this.WORD_MISSING);
        }
        if ((postDo = matcher.groupNodes("$post_do")) != null) {
            sentence.addAll(postDo);
        }
        if (sentence.size() > 2 && !"IN".equals(sentence.get(sentence.size() - 2).tag()) && "CD".equals(sentence.get(sentence.size() - 1).tag())) {
            sentence.add(sentence.size() - 1, this.WORD_IN);
        }
        return sentence;
    }

    private List<CoreLabel> processWhenDo(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$statement_body");
        List in = matcher.groupNodes("$in");
        if (in != null && in.size() > 0) {
            sentence.addAll(in);
        } else {
            sentence.add(this.WORD_IN);
        }
        sentence.add(this.WORD_MISSING_TIME);
        return sentence;
    }

    private List<CoreLabel> processWhatHave(TokenSequenceMatcher matcher) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        List preVerb = matcher.groupNodes("$pre_verb");
        if (preVerb != null) {
            sentence.addAll(preVerb);
        }
        if (sentence.size() == 0) {
            sentence.add(this.WORD_MISSING);
            sentence.addAll(matcher.groupNodes("$have"));
            sentence.addAll(matcher.groupNodes("$verb"));
        } else {
            sentence.addAll(matcher.groupNodes("$have"));
            sentence.addAll(matcher.groupNodes("$verb"));
            sentence.add(this.WORD_MISSING);
        }
        List postVerb = matcher.groupNodes("$post_verb");
        if (postVerb != null) {
            sentence.addAll(postVerb);
        }
        return sentence;
    }

    private List<CoreLabel> processHow(TokenSequenceMatcher matcher) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        List prp = matcher.groupNodes("$prp0");
        if (prp == null || prp.isEmpty()) {
            prp = matcher.groupNodes("$prp1");
        }
        if (prp != null && !prp.isEmpty()) {
            sentence.addAll(prp);
            List doOrCan = matcher.groupNodes("$do");
            if (doOrCan != null && doOrCan.size() == 1 && "can".equalsIgnoreCase(((CoreLabel)doOrCan.get(0)).lemma())) {
                sentence.addAll(doOrCan);
            }
        }
        sentence.addAll(matcher.groupNodes("$statement_body"));
        List wordBe = matcher.groupNodes("$be");
        if (wordBe != null) {
            sentence.addAll(wordBe);
            sentence.add(this.WORD_ADJECTIVE);
        } else {
            sentence.add(this.WORD_WAY);
        }
        return sentence;
    }

    private List<CoreLabel> processHowMuchDo(TokenSequenceMatcher matcher) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>(matcher.groupNodes("$prefix"));
        List connective = matcher.groupNodes("$connective");
        if (connective != null && !connective.isEmpty()) {
            sentence.add(this.WORD_MISSING);
            sentence.addAll(connective);
            sentence.addAll(matcher.groupNodes("$suffix"));
        } else {
            sentence.addAll(matcher.groupNodes("$suffix"));
            sentence.add(this.WORD_WAY);
        }
        return sentence;
    }

    /*
     * WARNING - void declaration
     */
    private List<List<CoreLabel>> postProcess(List<CoreLabel> question, List<CoreLabel> statement) {
        void var6_21;
        Object originalText;
        block68: for (CoreLabel token : statement) {
            originalText = token.originalText();
            if (originalText == null || "".equals(originalText)) {
                originalText = token.word();
            }
            switch (((String)originalText).toLowerCase()) {
                case "i": {
                    token.set(CoreAnnotations.StatementTextAnnotation.class, "you");
                    continue block68;
                }
                case "you": {
                    token.set(CoreAnnotations.StatementTextAnnotation.class, "i");
                    continue block68;
                }
                case "my": {
                    token.set(CoreAnnotations.StatementTextAnnotation.class, "your");
                    continue block68;
                }
                case "your": {
                    token.set(CoreAnnotations.StatementTextAnnotation.class, "my");
                    continue block68;
                }
            }
            token.set(CoreAnnotations.StatementTextAnnotation.class, originalText);
        }
        block69: for (int i = 0; i < statement.size(); ++i) {
            Object object;
            CoreLabel token;
            token = statement.get(i);
            originalText = (String)token.get(CoreAnnotations.StatementTextAnnotation.class);
            Object object2 = object = ((String)originalText).length() == 0 ? originalText : Character.toUpperCase(((String)originalText).charAt(0)) + ((String)originalText).substring(1);
            if (i == 0) {
                token.set(CoreAnnotations.StatementTextAnnotation.class, object);
                continue;
            }
            if (Optional.ofNullable(token.tag()).map(x -> x.startsWith("NNP")).orElse(false).booleanValue()) {
                token.set(CoreAnnotations.StatementTextAnnotation.class, object);
                continue;
            }
            switch (((String)originalText).toLowerCase()) {
                case "i": {
                    token.set(CoreAnnotations.StatementTextAnnotation.class, object);
                    continue block69;
                }
                default: {
                    token.set(CoreAnnotations.StatementTextAnnotation.class, ((String)originalText).toLowerCase());
                }
            }
        }
        boolean past = false;
        boolean participle = false;
        block70: for (CoreLabel coreLabel : question) {
            switch (Optional.ofNullable(coreLabel.lemma()).orElse(coreLabel.word()).toLowerCase()) {
                case "do": {
                    switch (coreLabel.tag()) {
                        case "VBG": {
                            participle = true;
                        }
                        case "VB": {
                            past = false;
                            break block70;
                        }
                        case "VBN": {
                            participle = true;
                        }
                        case "VBD": {
                            past = true;
                            break block70;
                        }
                    }
                }
                default: {
                    continue block70;
                }
            }
        }
        boolean plural = false;
        block71: for (CoreLabel token : statement) {
            switch (Optional.ofNullable(token.tag()).orElse("")) {
                case "NN": 
                case "NNP": {
                    plural = false;
                    break block71;
                }
                case "NNS": 
                case "NNPS": {
                    plural = true;
                    break block71;
                }
                default: {
                    continue block71;
                }
            }
        }
        int n = 3;
        block72: for (CoreLabel token : statement) {
            if (Optional.ofNullable(token.tag()).map(x -> x.startsWith("N")).orElse(false).booleanValue()) break;
            switch (((String)token.get(CoreAnnotations.StatementTextAnnotation.class)).toLowerCase()) {
                case "us": {
                    plural = true;
                    boolean bl = true;
                    break block72;
                }
                case "i": 
                case "me": 
                case "mine": 
                case "my": {
                    plural = false;
                    boolean bl = true;
                    break block72;
                }
                case "you": {
                    plural = false;
                    int n2 = 2;
                    break block72;
                }
                case "they": 
                case "them": {
                    plural = true;
                    int n3 = 2;
                    break block72;
                }
                case "he": 
                case "she": 
                case "him": 
                case "her": 
                case "it": {
                    plural = false;
                    int n4 = 3;
                    break block72;
                }
                default: {
                    continue block72;
                }
            }
        }
        VerbTense tense = VerbTense.of(past, plural, participle, (int)var6_21);
        boolean foundVerb = false;
        for (CoreLabel token : statement) {
            if (!Optional.ofNullable(token.tag()).map(x -> x.startsWith("V") && !x.equals("VBG") && !"be".equals(token.word())).orElse(false).booleanValue()) continue;
            foundVerb = true;
            token.set(CoreAnnotations.StatementTextAnnotation.class, tense.conjugateEnglish((String)token.get(CoreAnnotations.StatementTextAnnotation.class), false));
        }
        if (!foundVerb) {
            for (CoreLabel token : statement) {
                if (!Optional.ofNullable(token.tag()).map("NN"::equals).orElse(false).booleanValue()) continue;
                token.set(CoreAnnotations.StatementTextAnnotation.class, tense.conjugateEnglish((String)token.get(CoreAnnotations.StatementTextAnnotation.class), false));
            }
        }
        return Collections.singletonList(statement);
    }

    public List<List<CoreLabel>> toStatement(List<CoreLabel> question) {
        TokenSequenceMatcher matcher = this.triggerWhatIsThere.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhatIsThere(matcher));
        }
        matcher = this.triggerWhNNWill.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhNNWill(matcher));
        }
        matcher = this.triggerWhNNIs.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhNNIs(matcher));
        }
        matcher = this.triggerWhNNHave.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhNNHaveIs(matcher));
        }
        matcher = this.triggerWhNNHaveNN.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhNNHaveNN(matcher));
        }
        matcher = this.triggerHow.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processHow(matcher));
        }
        matcher = this.triggerHowMuchDo.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processHowMuchDo(matcher));
        }
        matcher = this.triggerWhatIs.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhatIs(matcher));
        }
        matcher = this.triggerWhatHave.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhatHave(matcher));
        }
        matcher = this.triggerWhereDo.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhereDo(matcher, question));
        }
        matcher = this.triggerWhereIs.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhereIs(matcher));
        }
        matcher = this.triggerWhoIs.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhoIs(matcher));
        }
        matcher = this.triggerWhoDid.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhoDid(matcher));
        }
        matcher = this.triggerWhatDo.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhatDo(matcher));
        }
        matcher = this.triggerWhenDo.matcher(question);
        if (matcher.matches()) {
            return this.postProcess(question, this.processWhenDo(matcher));
        }
        return Collections.emptyList();
    }

    public static void main(String[] args) throws IOException {
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma"));
        QuestionToStatementTranslator translator = new QuestionToStatementTranslator();
        IOUtils.console("question> ", question -> {
            Annotation ann = new Annotation((String)question);
            pipeline.annotate(ann);
            List tokens = (List)ann.get(CoreAnnotations.TokensAnnotation.class);
            List<List<CoreLabel>> statements = translator.toStatement(tokens);
            for (List<CoreLabel> statement : statements) {
                System.out.println("  -> " + StringUtils.join(statement.stream().map(CoreLabel::word), " "));
            }
        });
    }

    public static class UnknownTokenMarker
    implements CoreAnnotation<Boolean> {
        @Override
        public Class<Boolean> getType() {
            return Boolean.class;
        }
    }
}

