/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.objectbank.ReaderIteratorFactory;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ResettableReaderIteratorFactory
extends ReaderIteratorFactory {
    public ResettableReaderIteratorFactory(Collection<?> c) {
        super(c);
    }

    public ResettableReaderIteratorFactory(Collection<?> c, String encoding) {
        super(c, encoding);
    }

    public ResettableReaderIteratorFactory(Object o) {
        super(o);
    }

    public ResettableReaderIteratorFactory(Object o, String encoding) {
        super(o, encoding);
    }

    public ResettableReaderIteratorFactory() {
    }

    @Override
    public Iterator<Reader> iterator() {
        ArrayList<File> newCollection = new ArrayList<File>();
        for (Object o : this.c) {
            if (o instanceof Reader) {
                File tmpFile;
                String name = o.toString() + ".tmp";
                try {
                    tmpFile = File.createTempFile(name, "");
                }
                catch (Exception e) {
                    throw new RuntimeIOException(e);
                }
                tmpFile.deleteOnExit();
                StringUtils.printToFile(tmpFile, IOUtils.slurpReader((Reader)o), false, false, this.enc);
                newCollection.add(tmpFile);
                continue;
            }
            newCollection.add((File)o);
        }
        this.c = newCollection;
        return new ReaderIteratorFactory.ReaderIterator();
    }
}

