/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class CandidatePhrase
implements Serializable,
Comparable {
    private final String phrase;
    private String phraseLemma;
    private Counter<String> features;
    private final int hashCode;
    private static final long serialVersionUID = 42L;
    private static final ConcurrentHashMap<String, CandidatePhrase> candidatePhraseMap = new ConcurrentHashMap();

    public static CandidatePhrase createOrGet(String phrase) {
        if (candidatePhraseMap.containsKey(phrase = phrase.trim())) {
            return candidatePhraseMap.get(phrase);
        }
        CandidatePhrase p = new CandidatePhrase(phrase);
        candidatePhraseMap.put(phrase, p);
        return p;
    }

    public static CandidatePhrase createOrGet(String phrase, String phraseLemma) {
        if (candidatePhraseMap.containsKey(phrase = phrase.trim())) {
            CandidatePhrase p = candidatePhraseMap.get(phrase);
            p.phraseLemma = phraseLemma;
            return p;
        }
        CandidatePhrase p = new CandidatePhrase(phrase, phraseLemma);
        candidatePhraseMap.put(phrase, p);
        return p;
    }

    public static CandidatePhrase createOrGet(String phrase, String phraseLemma, Counter<String> features) {
        if (candidatePhraseMap.containsKey(phrase = phrase.trim())) {
            CandidatePhrase p = candidatePhraseMap.get(phrase);
            p.phraseLemma = phraseLemma;
            if (features != null && features.size() > 0) {
                if (p.features == null) {
                    p.features = new ClassicCounter<String>();
                }
                p.features.addAll(features);
            }
            return p;
        }
        CandidatePhrase p = new CandidatePhrase(phrase, phraseLemma, features);
        candidatePhraseMap.put(phrase, p);
        return p;
    }

    private CandidatePhrase(String phrase, String lemma) {
        this(phrase, lemma, null);
    }

    private CandidatePhrase(String phrase, String lemma, Counter<String> features) {
        if (phrase.isEmpty()) {
            new Exception("Creating empty candidatePhrase").printStackTrace(System.out);
        }
        this.phrase = phrase;
        this.phraseLemma = lemma;
        this.features = features;
        this.hashCode = phrase.hashCode();
    }

    private CandidatePhrase(String w) {
        this(w, null, null);
    }

    public String getPhrase() {
        return this.phrase;
    }

    public String getPhraseLemma() {
        return this.phraseLemma;
    }

    public double getFeatureValue(String feat) {
        return this.features.getCount(feat);
    }

    public String toString() {
        return this.phrase;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CandidatePhrase)) {
            return false;
        }
        return this.hashCode == o.hashCode();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CandidatePhrase)) {
            return -1;
        }
        return ((CandidatePhrase)o).getPhrase().compareTo(this.getPhrase());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static List<CandidatePhrase> convertStringPhrases(Collection<String> str) {
        ArrayList<CandidatePhrase> phs = new ArrayList<CandidatePhrase>();
        for (String s : str) {
            phs.add(CandidatePhrase.createOrGet(s));
        }
        return phs;
    }

    public static List<String> convertToString(Collection<CandidatePhrase> words) {
        ArrayList<String> phs = new ArrayList<String>();
        for (CandidatePhrase ph : words) {
            phs.add(ph.getPhrase());
        }
        return phs;
    }

    public Counter<String> getFeatures() {
        return this.features;
    }

    public void addFeature(String s, double v) {
        if (this.features == null) {
            this.features = new ClassicCounter<String>();
        }
        this.features.setCount(s, v);
    }

    public void addFeatures(Collection<String> feat) {
        if (this.features == null) {
            this.features = new ClassicCounter<String>();
        }
        Counters.addInPlace(this.features, feat);
    }

    public void setPhraseLemma(String phraseLemma) {
        this.phraseLemma = phraseLemma;
    }

    public static void deletePhrase(CandidatePhrase p) {
        candidatePhraseMap.remove(p);
    }
}

