/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.international.arabic.process.ArabicSegmenter;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ArabicSegmenterAnnotator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ArabicSegmenterAnnotator.class);
    private ArabicSegmenter segmenter;
    private final boolean VERBOSE;
    private static final String DEFAULT_SEG_LOC = "/u/nlp/data/arabic-segmenter/arabic-segmenter-atb+bn+arztrain.ser.gz";

    public ArabicSegmenterAnnotator() {
        this(DEFAULT_SEG_LOC, false);
    }

    public ArabicSegmenterAnnotator(boolean verbose) {
        this(DEFAULT_SEG_LOC, verbose);
    }

    public ArabicSegmenterAnnotator(String segLoc, boolean verbose) {
        this.VERBOSE = verbose;
        Properties props = new Properties();
        this.loadModel(segLoc, props);
    }

    public ArabicSegmenterAnnotator(String name, Properties props) {
        String model = null;
        Properties modelProps = new Properties();
        String desiredKey = name + '.';
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(desiredKey)) continue;
            String modelKey = key.substring(desiredKey.length());
            if (modelKey.equals("model")) {
                model = props.getProperty(key);
                continue;
            }
            modelProps.setProperty(modelKey, props.getProperty(key));
        }
        this.VERBOSE = PropertiesUtils.getBool(props, name + ".verbose", false);
        if (model == null) {
            throw new RuntimeException("Expected a property " + name + ".model");
        }
        this.loadModel(model, modelProps);
    }

    private void loadModel(String segLoc) {
        if (this.VERBOSE) {
            log.info("Loading segmentation model ... ");
        }
        Properties modelProps = new Properties();
        modelProps.setProperty("model", segLoc);
        this.segmenter = ArabicSegmenter.getSegmenter(modelProps);
    }

    private void loadModel(String segLoc, Properties props) {
        if (this.VERBOSE) {
            log.info("Loading Segmentation Model ... ");
        }
        Properties modelProps = new Properties();
        modelProps.setProperty("model", segLoc);
        modelProps.putAll((Map<?, ?>)props);
        try {
            this.segmenter = ArabicSegmenter.getSegmenter(modelProps);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        List sentences;
        if (this.VERBOSE) {
            log.info("Adding Segmentation annotation ... ");
        }
        if ((sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) != null) {
            for (CoreMap sentence : sentences) {
                this.doOneSentence(sentence);
            }
        } else {
            this.doOneSentence(annotation);
        }
    }

    private void doOneSentence(CoreMap annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        List<CoreLabel> tokens = this.segmenter.segmentStringToTokenList(text);
        annotation.set(CoreAnnotations.TokensAnnotation.class, tokens);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.PositionAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.ValueAnnotation.class));
    }
}

