/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.types.Tags;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.DocDateAnnotator;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.LanguageInfo;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexNERAnnotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class NERCombinerAnnotator
extends SentenceAnnotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(NERCombinerAnnotator.class);
    private final NERClassifierCombiner ner;
    private final boolean VERBOSE;
    private boolean setDocDate = false;
    private final long maxTime;
    private final int nThreads;
    private final int maxSentenceLength;
    private LanguageInfo.HumanLanguage language = LanguageInfo.HumanLanguage.ENGLISH;
    private static final Map<String, String> spanishToEnglishTag = new HashMap<String, String>();
    private static final String spanishNumberRegexRules = "edu/stanford/nlp/models/kbp/spanish/gazetteers/kbp_regexner_number_sp.tag";
    private TokensRegexNERAnnotator spanishNumberAnnotator;
    private boolean applyFineGrained = true;
    private TokensRegexNERAnnotator fineGrainedNERAnnotator;
    private boolean applyAdditionalRules = true;
    private TokensRegexNERAnnotator additionalRulesNERAnnotator;
    private boolean applyTokensRegexRules = false;
    private TokensRegexAnnotator tokensRegexAnnotator;
    private boolean buildEntityMentions = true;
    private EntityMentionsAnnotator entityMentionsAnnotator;
    private DocDateAnnotator docDateAnnotator;

    public NERCombinerAnnotator(Properties properties) throws IOException {
        ArrayList<String> models = new ArrayList<String>();
        String modelNames = properties.getProperty("ner.model");
        if (modelNames == null) {
            modelNames = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
        }
        if (!modelNames.isEmpty()) {
            models.addAll(Arrays.asList(modelNames.split(",")));
        }
        if (models.isEmpty()) {
            log.info("WARNING: no NER models specified");
        }
        boolean applyNumericClassifiers = PropertiesUtils.getBool(properties, "ner.applyNumericClassifiers", true);
        boolean useSUTime = PropertiesUtils.getBool(properties, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
        NERClassifierCombiner.Language nerLanguage = NERClassifierCombiner.Language.fromString(PropertiesUtils.getString(properties, "ner.language", null), NERClassifierCombiner.NER_LANGUAGE_DEFAULT);
        boolean verbose = PropertiesUtils.getBool(properties, "ner.verbose", false);
        String[] loadPaths = models.toArray(new String[models.size()]);
        Properties combinerProperties = PropertiesUtils.extractSelectedProperties(properties, NERClassifierCombiner.DEFAULT_PASS_DOWN_PROPERTIES);
        if (useSUTime) {
            Properties sutimeProps = PropertiesUtils.extractPrefixedProperties(properties, "sutime.", true);
            PropertiesUtils.overWriteProperties(combinerProperties, sutimeProps);
        }
        NERClassifierCombiner nerCombiner = new NERClassifierCombiner(applyNumericClassifiers, nerLanguage, useSUTime, combinerProperties, loadPaths);
        this.nThreads = PropertiesUtils.getInt(properties, "ner.nthreads", PropertiesUtils.getInt(properties, "nthreads", 1));
        this.maxTime = PropertiesUtils.getLong(properties, "ner.maxtime", 0L);
        this.maxSentenceLength = PropertiesUtils.getInt(properties, "ner.maxlen", Integer.MAX_VALUE);
        this.language = LanguageInfo.getLanguageFromString(PropertiesUtils.getString(properties, "ner.language", "en"));
        if (this.language.equals((Object)LanguageInfo.HumanLanguage.SPANISH)) {
            Properties spanishNumberRegexNerProperties = new Properties();
            spanishNumberRegexNerProperties.setProperty("spanish.number.regexner.mapping", spanishNumberRegexRules);
            spanishNumberRegexNerProperties.setProperty("spanish.number.regexner.validpospattern", "^(NUM).*");
            spanishNumberRegexNerProperties.setProperty("spanish.number.regexner.ignorecase", "true");
            this.spanishNumberAnnotator = new TokensRegexNERAnnotator("spanish.number.regexner", spanishNumberRegexNerProperties);
        }
        this.setUpFineGrainedNER(properties);
        this.setUpAdditionalRulesNER(properties);
        this.setUpTokensRegexRules(properties);
        this.setUpEntityMentionBuilding(properties);
        this.setUpDocDateAnnotator(properties);
        this.VERBOSE = verbose;
        this.ner = nerCombiner;
    }

    public NERCombinerAnnotator() throws IOException, ClassNotFoundException {
        this(true);
    }

    public NERCombinerAnnotator(boolean verbose) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(new Properties()), verbose);
    }

    public NERCombinerAnnotator(boolean verbose, String ... classifiers) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(classifiers), verbose);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose) {
        this(ner, verbose, 1, 0L, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime) {
        this(ner, verbose, nThreads, maxTime, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime, int maxSentenceLength) {
        this(ner, verbose, nThreads, maxTime, maxSentenceLength, true, true);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime, int maxSentenceLength, boolean fineGrained, boolean entityMentions) {
        this.VERBOSE = verbose;
        this.ner = ner;
        this.maxTime = maxTime;
        this.nThreads = nThreads;
        this.maxSentenceLength = maxSentenceLength;
        Properties nerProperties = new Properties();
        nerProperties.setProperty("ner.applyFineGrained", Boolean.toString(fineGrained));
        nerProperties.setProperty("ner.buildEntityMentions", Boolean.toString(entityMentions));
        this.setUpAdditionalRulesNER(nerProperties);
        this.setUpFineGrainedNER(nerProperties);
        this.setUpEntityMentionBuilding(nerProperties);
    }

    public void setUpFineGrainedNER(Properties properties) {
        this.applyFineGrained = PropertiesUtils.getBool(properties, "ner.applyFineGrained", true);
        if (this.applyFineGrained) {
            String fineGrainedPrefix = "ner.fine.regexner";
            Properties fineGrainedProps = PropertiesUtils.extractPrefixedProperties(properties, fineGrainedPrefix + ".", true);
            if (!fineGrainedProps.containsKey("ner.fine.regexner.mapping")) {
                fineGrainedProps.setProperty("ner.fine.regexner.mapping", "ignorecase=true,validpospattern=^(NN|JJ).*,edu/stanford/nlp/models/kbp/english/gazetteers/regexner_caseless.tab;edu/stanford/nlp/models/kbp/english/gazetteers/regexner_cased.tab");
            }
            this.fineGrainedNERAnnotator = new TokensRegexNERAnnotator(fineGrainedPrefix, fineGrainedProps);
        }
    }

    public void setUpAdditionalRulesNER(Properties properties) {
        boolean bl = this.applyAdditionalRules = !properties.getProperty("ner.additional.regexner.mapping", "").equals("");
        if (this.applyAdditionalRules) {
            String additionalRulesPrefix = "ner.additional.regexner";
            Properties additionalRulesProps = PropertiesUtils.extractPrefixedProperties(properties, additionalRulesPrefix + ".", true);
            this.additionalRulesNERAnnotator = new TokensRegexNERAnnotator(additionalRulesPrefix, additionalRulesProps);
        }
    }

    public void setUpTokensRegexRules(Properties properties) {
        boolean bl = this.applyTokensRegexRules = !properties.getProperty("ner.additional.tokensregex.rules", "").equals("");
        if (this.applyTokensRegexRules) {
            String tokensRegexRulesPrefix = "ner.additional.tokensregex";
            Properties tokensRegexRulesProps = PropertiesUtils.extractPrefixedProperties(properties, tokensRegexRulesPrefix + ".", true);
            this.tokensRegexAnnotator = new TokensRegexAnnotator(tokensRegexRulesPrefix, tokensRegexRulesProps);
        }
    }

    public void setUpEntityMentionBuilding(Properties properties) {
        this.buildEntityMentions = PropertiesUtils.getBool(properties, "ner.buildEntityMentions", true);
        if (this.buildEntityMentions) {
            String entityMentionsPrefix = "ner.entitymentions";
            Properties entityMentionsProps = PropertiesUtils.extractPrefixedProperties(properties, entityMentionsPrefix + ".", true);
            entityMentionsProps.setProperty("ner.entitymentions.language", this.language.name());
            this.entityMentionsAnnotator = new EntityMentionsAnnotator(entityMentionsPrefix, entityMentionsProps);
        }
    }

    public void setUpDocDateAnnotator(Properties properties) throws IOException {
        for (String property : properties.stringPropertyNames()) {
            if (property.length() < 11 || !property.substring(0, 11).equals("ner.docdate")) continue;
            this.setDocDate = true;
            this.docDateAnnotator = new DocDateAnnotator("ner.docdate", properties);
            break;
        }
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxTime;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            log.info("Adding NER Combiner annotation ... ");
        }
        if (this.setDocDate) {
            this.docDateAnnotator.annotate(annotation);
        }
        super.annotate(annotation);
        this.ner.finalizeAnnotation(annotation);
        if (this.VERBOSE) {
            log.info("done.");
        }
        if (LanguageInfo.HumanLanguage.SPANISH.equals((Object)this.language)) {
            this.spanishNumberAnnotator.annotate(annotation);
        }
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            if (!token.ner().equals("MONEY") && !token.ner().equals("NUMBER")) continue;
            token.remove(TimeAnnotations.TimexAnnotation.class);
        }
        if (this.applyFineGrained || this.applyAdditionalRules) {
            if (this.applyFineGrained) {
                this.fineGrainedNERAnnotator.annotate(annotation);
            }
            if (this.applyAdditionalRules) {
                this.additionalRulesNERAnnotator.annotate(annotation);
            }
            if (this.applyTokensRegexRules) {
                this.tokensRegexAnnotator.annotate(annotation);
            }
            for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
                String fineGrainedTag = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                token.set(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class, fineGrainedTag);
            }
        }
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            if (token.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class) != null) continue;
            Map<String, Double> labelToProb = Collections.singletonMap(token.ner(), -1.0);
            token.set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, labelToProb);
        }
        if (this.buildEntityMentions) {
            this.entityMentionsAnnotator.annotate(annotation);
        }
    }

    public static String spanishToEnglishTag(String spanishTag) {
        return spanishToEnglishTag.getOrDefault(spanishTag, spanishTag);
    }

    @Override
    public void doOneSentence(Annotation annotation, CoreMap sentence) {
        List output;
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens.size() <= this.maxSentenceLength) {
            try {
                output = this.ner.classifySentenceWithGlobalInformation(tokens, annotation, sentence);
            }
            catch (RuntimeInterruptedException e) {
                output = null;
            }
        } else {
            output = null;
        }
        if (output == null) {
            this.doOneFailedSentence(annotation, sentence);
        } else {
            int sz = tokens.size();
            for (int i = 0; i < sz; ++i) {
                String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String normNeTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                Map neTagProbMap = (Map)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
                if (this.language.equals((Object)LanguageInfo.HumanLanguage.SPANISH)) {
                    neTag = NERCombinerAnnotator.spanishToEnglishTag(neTag);
                    normNeTag = NERCombinerAnnotator.spanishToEnglishTag(normNeTag);
                }
                ((CoreLabel)tokens.get(i)).setNER(neTag);
                ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, neTagProbMap);
                ((CoreLabel)tokens.get(i)).set(CoreAnnotations.CoarseNamedEntityTagAnnotation.class, neTag);
                if (normNeTag != null) {
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, normNeTag);
                }
                NumberSequenceClassifier.transferAnnotations((CoreLabel)output.get(i), (CoreLabel)tokens.get(i));
            }
            if (this.VERBOSE) {
                boolean first = true;
                StringBuilder sb = new StringBuilder("NERCombinerAnnotator output: [");
                for (CoreLabel w : tokens) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(w.toShorterString("Text", "NamedEntityTag", "NormalizedNamedEntityTag"));
                }
                sb.append(']');
                log.info(sb);
            }
        }
    }

    @Override
    public void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            if (token.ner() != null) continue;
            token.setNER(this.ner.backgroundSymbol());
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        if (this.ner.usesSUTime() || this.ner.appliesNumericClassifiers()) {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.IsNewlineAnnotation.class)));
        }
        return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.IsNewlineAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        HashSet<Class<? extends CoreAnnotation>> nerRequirementsSatisfied = new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, CoreAnnotations.ValueAnnotation.class, TimeExpression.Annotation.class, TimeExpression.TimeIndexAnnotation.class, CoreAnnotations.DistSimAnnotation.class, CoreAnnotations.NumericCompositeTypeAnnotation.class, TimeAnnotations.TimexAnnotation.class, CoreAnnotations.NumericValueAnnotation.class, TimeExpression.ChildrenAnnotation.class, CoreAnnotations.NumericTypeAnnotation.class, CoreAnnotations.ShapeAnnotation.class, Tags.TagsAnnotation.class, CoreAnnotations.NumerizedTokensAnnotation.class, CoreAnnotations.AnswerAnnotation.class, CoreAnnotations.NumericCompositeValueAnnotation.class, CoreAnnotations.CoarseNamedEntityTagAnnotation.class, CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class));
        if (this.buildEntityMentions) {
            nerRequirementsSatisfied.add(CoreAnnotations.MentionsAnnotation.class);
            nerRequirementsSatisfied.add(CoreAnnotations.EntityTypeAnnotation.class);
            nerRequirementsSatisfied.add(CoreAnnotations.EntityMentionIndexAnnotation.class);
        }
        return nerRequirementsSatisfied;
    }

    static {
        spanishToEnglishTag.put("PERS", "PERSON");
        spanishToEnglishTag.put("ORG", "ORGANIZATION");
        spanishToEnglishTag.put("LUG", "LOCATION");
        spanishToEnglishTag.put("OTROS", "MISC");
    }
}

