/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.io.StringOutputStream;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private static final Document document = XMLUtils.createDocument();
    private static final TransformerFactory tFactory = TransformerFactory.newInstance();

    private XMLUtils() {
    }

    public static String documentToString(Document document) {
        StringOutputStream s = new StringOutputStream();
        XMLUtils.printNode(s, document, true, true);
        return s.toString();
    }

    public static String nodeToString(Node node, boolean prettyPrint) {
        StringOutputStream s = new StringOutputStream();
        XMLUtils.printNode(s, node, prettyPrint, false);
        return s.toString();
    }

    public static void printNode(OutputStream out2, Node node, boolean prettyPrint, boolean includeXmlDeclaration) {
        try {
            Transformer serializer = tFactory.newTransformer();
            if (prettyPrint) {
                serializer.setOutputProperty("indent", "yes");
                serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            if (!includeXmlDeclaration) {
                serializer.setOutputProperty("omit-xml-declaration", "yes");
            }
            DOMSource xmlSource = new DOMSource(node);
            StreamResult outputTarget = new StreamResult(out2);
            serializer.transform(xmlSource, outputTarget);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Text createTextNode(String text) {
        return document.createTextNode(text);
    }

    public static Element createElement(String tag) {
        return document.createElement(tag);
    }

    public static Element parseElement(String xml) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAttribute(Element element, String name) {
        Attr attr = element.getAttributeNode(name);
        return attr != null ? attr.getValue() : null;
    }

    public static void removeChildren(Node e) {
        NodeList list = e.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            e.removeChild(n);
        }
    }

    private static void getMatchingNodes(Node node, Pattern[] nodePath, int cur, List<Node> res) {
        if (cur < 0 || cur >= nodePath.length) {
            return;
        }
        boolean last = cur == nodePath.length - 1;
        Pattern pattern = nodePath[cur];
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (!pattern.matcher(c.getNodeName()).matches()) continue;
            if (last) {
                res.add(c);
                continue;
            }
            XMLUtils.getMatchingNodes(c, nodePath, cur + 1, res);
        }
    }

    public static List<Node> getNodes(Node node, Pattern ... nodePath) {
        ArrayList<Node> res = new ArrayList<Node>();
        XMLUtils.getMatchingNodes(node, nodePath, 0, res);
        return res;
    }

    public static String getNodeText(Node node, Pattern ... nodePath) {
        List<Node> nodes = XMLUtils.getNodes(node, nodePath);
        if (nodes != null && nodes.size() > 0) {
            return nodes.get(0).getTextContent();
        }
        return null;
    }

    public static Node getNode(Node node, Pattern ... nodePath) {
        List<Node> nodes = XMLUtils.getNodes(node, nodePath);
        if (nodes != null && nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    private static void getMatchingNodes(Node node, String[] nodePath, int cur, List<Node> res) {
        if (cur < 0 || cur >= nodePath.length) {
            return;
        }
        boolean last = cur == nodePath.length - 1;
        String name = nodePath[cur];
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node c = children.item(i);
                if (!name.equals(c.getNodeName())) continue;
                if (last) {
                    res.add(c);
                    continue;
                }
                XMLUtils.getMatchingNodes(c, nodePath, cur + 1, res);
            }
        }
    }

    public static List<Node> getNodes(Node node, String ... nodePath) {
        ArrayList<Node> res = new ArrayList<Node>();
        XMLUtils.getMatchingNodes(node, nodePath, 0, res);
        return res;
    }

    public static List<String> getNodeTexts(Node node, String ... nodePath) {
        List<Node> nodes = XMLUtils.getNodes(node, nodePath);
        if (nodes != null) {
            ArrayList<String> strs = new ArrayList<String>(nodes.size());
            for (Node n : nodes) {
                strs.add(n.getTextContent());
            }
            return strs;
        }
        return null;
    }

    public static String getNodeText(Node node, String ... nodePath) {
        List<Node> nodes = XMLUtils.getNodes(node, nodePath);
        if (nodes != null && nodes.size() > 0) {
            return nodes.get(0).getTextContent();
        }
        return null;
    }

    public static String getAttributeValue(Node node, String name) {
        Node attr = XMLUtils.getAttribute(node, name);
        return attr != null ? attr.getNodeValue() : null;
    }

    public static Node getAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name);
    }

    public static Node getNode(Node node, String ... nodePath) {
        List<Node> nodes = XMLUtils.getNodes(node, nodePath);
        if (nodes != null && nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }
}

