/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.xwpf.converter.core.BorderSide;
import org.apache.poi.xwpf.converter.core.Color;
import org.apache.poi.xwpf.converter.core.ParagraphLineSpacing;
import org.apache.poi.xwpf.converter.core.TableCellBorder;
import org.apache.poi.xwpf.converter.core.TableHeight;
import org.apache.poi.xwpf.converter.core.TableWidth;
import org.apache.poi.xwpf.converter.core.openxmlformats.IOpenXMLFormatsPartProvider;
import org.apache.poi.xwpf.converter.core.styles.TableCellInfo;
import org.apache.poi.xwpf.converter.core.styles.TableInfo;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphAlignmentValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphBackgroundColorValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphBorderBottomValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphBorderLeftValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphBorderRightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphBorderTopValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphIndentationFirstLineValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphIndentationHangingValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphIndentationLeftValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphIndentationRightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphLineSpacingValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphNumPrValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphSpacingAfterValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphSpacingBeforeValueProvider;
import org.apache.poi.xwpf.converter.core.styles.paragraph.ParagraphTabsValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunBackgroundColorValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontColorValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontFamilyAsciiValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontFamilyEastAsiaValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontFamilyHAnsiValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontSizeValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontStyleBoldValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontStyleItalicValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunFontStyleStrikeValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunTextHighlightingValueProvider;
import org.apache.poi.xwpf.converter.core.styles.run.RunUnderlineValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableAlignmentValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableBorderBottomValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableBorderInsideHValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableBorderInsideVValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableBorderLeftValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableBorderRightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableBorderTopValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableIndentationValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableMarginBottomValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableMarginLeftValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableMarginRightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableMarginTopValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.TableWidthValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellBackgroundColorValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellBorderBottomValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellBorderInsideHValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellBorderInsideVValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellBorderLeftValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellBorderRightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellBorderTopValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellGridSpanValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellMarginBottomValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellMarginLeftValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellMarginRightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellMarginTopValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellNoWrapValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellTextDirectionValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellVMergeValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellVerticalAlignmentValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.cell.TableCellWidthValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.row.TableRowHeaderValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.row.TableRowHeightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.row.TableRowMarginBottomValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.row.TableRowMarginLeftValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.row.TableRowMarginRightValueProvider;
import org.apache.poi.xwpf.converter.core.styles.table.row.TableRowMarginTopValueProvider;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSettings;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFont;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSettings;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrEx;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblStylePr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextDirection;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FontsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblStyleOverrideType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.SettingsDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFStylesDocument {
    public static final Object EMPTY_VALUE = new Object();
    private static final float DEFAULT_TAB_STOP_POINT = DxaUtil.dxa2points(720.0f);
    private final Map<String, CTStyle> stylesByStyleId;
    private CTStyle defaultParagraphStyle;
    private CTStyle defaultTableStyle;
    private final Map<String, Object> values;
    private CTStyle defaultCharacterStyle;
    private CTStyle defaultNumberingStyle;
    private Map<XWPFTable, TableInfo> tableInfos;
    private Float defaultTabStop;
    private CTSettings ctSettings;
    private List<ThemeDocument> themeDocuments;
    private final Map<String, List<String>> fontsAltName;
    private final Map<String, String> fontsToUse;
    private CTStyles styles;

    public XWPFStylesDocument(XWPFDocument document) throws XmlException, IOException {
        this(document, true);
    }

    public XWPFStylesDocument(XWPFDocument document, boolean lazyInitialization) throws XmlException, IOException {
        this(document.getStyle(), XWPFStylesDocument.getFontsDocument(document), XWPFStylesDocument.getThemeDocuments(document), XWPFStylesDocument.getCTSettings(document), lazyInitialization);
    }

    public XWPFStylesDocument(IOpenXMLFormatsPartProvider provider) throws Exception {
        this(provider, true);
    }

    public XWPFStylesDocument(IOpenXMLFormatsPartProvider provider, boolean lazyInitialization) throws Exception {
        this(provider.getStyle(), provider.getFontsDocument(), provider.getThemeDocuments(), provider.getSettings(), lazyInitialization);
    }

    public XWPFStylesDocument(CTStyles styles, List<FontsDocument> fontsDocuments, List<ThemeDocument> themeDocuments, CTSettings ctSettings, boolean lazyInitialization) throws XmlException, IOException {
        this.styles = styles;
        this.stylesByStyleId = new HashMap<String, CTStyle>();
        this.values = new HashMap<String, Object>();
        this.fontsAltName = this.updateFonts(fontsDocuments);
        this.fontsToUse = new HashMap<String, String>();
        this.themeDocuments = themeDocuments;
        this.ctSettings = ctSettings;
        if (lazyInitialization) {
            this.initialize();
        }
    }

    private Map<String, List<String>> updateFonts(List<FontsDocument> fontsDocuments) {
        HashMap<String, List<String>> fontsAltName = new HashMap<String, List<String>>();
        for (FontsDocument fontsDocument : fontsDocuments) {
            CTString altName = null;
            List fonts = fontsDocument.getFonts().getFontList();
            for (CTFont font : fonts) {
                altName = font.getAltName();
                if (altName == null || !StringUtils.isNotEmpty(altName.getVal())) continue;
                ArrayList<String> altNames = new ArrayList<String>();
                String[] names = altName.getVal().split(",");
                String name = null;
                for (int i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (!StringUtils.isNotEmpty(name)) continue;
                    altNames.add(name);
                }
                fontsAltName.put(font.getName(), altNames);
            }
        }
        return fontsAltName;
    }

    protected void initialize() throws XmlException, IOException {
        List s = this.styles.getStyleList();
        for (CTStyle style : s) {
            boolean isDefaultStyle;
            STOnOff.Enum isDefault = style.getDefault();
            STStyleType.Enum type = style.getType();
            boolean bl = isDefaultStyle = isDefault != null && isDefault.intValue() == 6;
            if (isDefaultStyle && type != null) {
                switch (type.intValue()) {
                    case 2: {
                        this.defaultCharacterStyle = style;
                        break;
                    }
                    case 4: {
                        this.defaultNumberingStyle = style;
                        break;
                    }
                    case 1: {
                        this.defaultParagraphStyle = style;
                        break;
                    }
                    case 3: {
                        this.defaultTableStyle = style;
                    }
                }
            }
            this.visitStyle(style, isDefaultStyle);
            this.stylesByStyleId.put(style.getStyleId(), style);
        }
    }

    protected void visitStyle(CTStyle style, boolean defaultStyle) {
    }

    public CTStyle getDefaultParagraphStyle() {
        return this.defaultParagraphStyle;
    }

    public CTStyle getStyle(String styleId) {
        return this.stylesByStyleId.get(styleId);
    }

    public CTDocDefaults getDocDefaults() {
        try {
            return this.styles.getDocDefaults();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Float getSpacingBefore(XWPFParagraph docxParagraph) {
        return (Float)ParagraphSpacingBeforeValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public Float getSpacingBefore(CTPPr pPr) {
        return (Float)ParagraphSpacingBeforeValueProvider.INSTANCE.getValue(pPr);
    }

    public Float getSpacingBefore(CTP paragraph, CTTbl table) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphSpacingBeforeValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public Float getSpacingAfter(XWPFParagraph docxParagraph) {
        return (Float)ParagraphSpacingAfterValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public Float getSpacingAfter(CTPPr pPr) {
        return (Float)ParagraphSpacingAfterValueProvider.INSTANCE.getValue(pPr);
    }

    public Float getSpacingAfter(CTP paragraph, CTTbl table) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphSpacingAfterValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public Float getIndentationLeft(XWPFParagraph paragraph) {
        return (Float)ParagraphIndentationLeftValueProvider.INSTANCE.getValue(paragraph, this);
    }

    public Float getIndentationLeft(CTPPr pPr) {
        return (Float)ParagraphIndentationLeftValueProvider.INSTANCE.getValue(pPr);
    }

    public Float getIndentationLeft(CTP paragraph, CTTbl table) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphIndentationLeftValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public Float getIndentationRight(XWPFParagraph paragraph) {
        return (Float)ParagraphIndentationRightValueProvider.INSTANCE.getValue(paragraph, this);
    }

    public Float getIndentationRight(CTPPr pPr) {
        return (Float)ParagraphIndentationRightValueProvider.INSTANCE.getValue(pPr);
    }

    public Float getIndentationRight(CTP paragraph, CTTbl table) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphIndentationRightValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public Float getIndentationFirstLine(XWPFParagraph paragraph) {
        return (Float)ParagraphIndentationFirstLineValueProvider.INSTANCE.getValue(paragraph, this);
    }

    public Float getIndentationFirstLine(CTPPr pPr) {
        return (Float)ParagraphIndentationFirstLineValueProvider.INSTANCE.getValue(pPr);
    }

    public Float getIndentationFirstLine(CTP paragraph, CTTbl table) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphIndentationFirstLineValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public Float getIndentationHanging(XWPFParagraph paragraph) {
        return (Float)ParagraphIndentationHangingValueProvider.INSTANCE.getValue(paragraph, this);
    }

    public Float getIndentationHanging(CTPPr pPr) {
        return (Float)ParagraphIndentationHangingValueProvider.INSTANCE.getValue(pPr);
    }

    public Float getIndentationHanging(CTP paragraph, CTTbl table) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphIndentationHangingValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public Color getBackgroundColor(XWPFParagraph paragraph) {
        return (Color)ParagraphBackgroundColorValueProvider.INSTANCE.getValue(paragraph, this);
    }

    public Color getBackgroundColor(CTPPr pPr) {
        return ParagraphBackgroundColorValueProvider.INSTANCE.getValue(pPr);
    }

    public ParagraphAlignment getParagraphAlignment(XWPFParagraph paragraph) {
        return (ParagraphAlignment)ParagraphAlignmentValueProvider.INSTANCE.getValue(paragraph, this);
    }

    public ParagraphAlignment getParagraphAlignment(CTPPr pPr) {
        return ParagraphAlignmentValueProvider.INSTANCE.getValue(pPr);
    }

    public ParagraphAlignment getParagraphAlignment(CTP paragraph, CTTbl table) {
        return (ParagraphAlignment)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphAlignmentValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public CTBorder getBorderTop(XWPFParagraph docxParagraph) {
        return (CTBorder)ParagraphBorderTopValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public CTBorder getBorderTop(CTPPr pPr) {
        return ParagraphBorderTopValueProvider.INSTANCE.getValue(pPr);
    }

    public CTBorder getBorderBottom(XWPFParagraph docxParagraph) {
        return (CTBorder)ParagraphBorderBottomValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public CTBorder getBorderBottom(CTPPr pPr) {
        return ParagraphBorderBottomValueProvider.INSTANCE.getValue(pPr);
    }

    public CTBorder getBorderLeft(XWPFParagraph docxParagraph) {
        return (CTBorder)ParagraphBorderLeftValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public CTBorder getBorderLeft(CTPPr pPr) {
        return ParagraphBorderLeftValueProvider.INSTANCE.getValue(pPr);
    }

    public CTBorder getBorderRight(XWPFParagraph docxParagraph) {
        return (CTBorder)ParagraphBorderRightValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public CTBorder getBorderRight(CTPPr pPr) {
        return ParagraphBorderRightValueProvider.INSTANCE.getValue(pPr);
    }

    public CTTabs getParagraphTabs(XWPFParagraph docxParagraph) {
        return (CTTabs)ParagraphTabsValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public CTTabs getParagraphTabs(CTPPr pPr) {
        return ParagraphTabsValueProvider.INSTANCE.getValue(pPr);
    }

    public ParagraphLineSpacing getParagraphSpacing(XWPFParagraph docxParagraph) {
        return (ParagraphLineSpacing)ParagraphLineSpacingValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public ParagraphLineSpacing getParagraphSpacing(CTPPr pPr) {
        return (ParagraphLineSpacing)ParagraphLineSpacingValueProvider.INSTANCE.getValue(pPr);
    }

    public ParagraphLineSpacing getParagraphSpacing(CTP paragraph, CTTbl table) {
        return (ParagraphLineSpacing)org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.ParagraphLineSpacingValueProvider.INSTANCE.getValue(paragraph, table, this);
    }

    public CTNumPr getParagraphNumPr(XWPFParagraph docxParagraph) {
        return (CTNumPr)ParagraphNumPrValueProvider.INSTANCE.getValue(docxParagraph, this);
    }

    public CTNumPr getParagraphNumPr(CTPPr pPr) {
        return ParagraphNumPrValueProvider.INSTANCE.getValue(pPr);
    }

    public String getFontFamilyAscii(XWPFRun run) {
        return (String)RunFontFamilyAsciiValueProvider.INSTANCE.getValue(run, this);
    }

    public String getFontFamilyAscii(CTRPr rPr) {
        return RunFontFamilyAsciiValueProvider.INSTANCE.getValue(rPr, this);
    }

    public String getFontFamilyAscii(CTR run, CTP paragraph) {
        return (String)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontFamilyAsciiValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public String getFontFamilyEastAsia(XWPFRun run) {
        return (String)RunFontFamilyEastAsiaValueProvider.INSTANCE.getValue(run, this);
    }

    public String getFontFamilyEastAsia(CTRPr rPr) {
        return RunFontFamilyEastAsiaValueProvider.INSTANCE.getValue(rPr, this);
    }

    public String getFontFamilyEastAsia(CTR run, CTP paragraph) {
        return (String)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontFamilyEastAsiaValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public String getFontFamilyHAnsi(XWPFRun run) {
        return (String)RunFontFamilyHAnsiValueProvider.INSTANCE.getValue(run, this);
    }

    public String getFontFamilyHAnsi(CTRPr rPr) {
        return RunFontFamilyHAnsiValueProvider.INSTANCE.getValue(rPr, this);
    }

    public String getFontFamilyHAnsi(CTR run, CTP paragraph) {
        return (String)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontFamilyHAnsiValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public Float getFontSize(XWPFRun run) {
        return (Float)RunFontSizeValueProvider.INSTANCE.getValue(run, this);
    }

    public Float getFontSize(CTR run, CTP paragraph) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontSizeValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public Float getFontSize(CTRPr rPr) {
        return RunFontSizeValueProvider.INSTANCE.getValue(rPr, this);
    }

    public Boolean getFontStyleBold(XWPFRun run) {
        return (Boolean)RunFontStyleBoldValueProvider.INSTANCE.getValue(run, this);
    }

    public Boolean getFontStyleBold(CTRPr rPr) {
        return RunFontStyleBoldValueProvider.INSTANCE.getValue(rPr, this);
    }

    public Boolean getFontStyleBold(CTR run, CTP paragraph) {
        return (Boolean)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontStyleBoldValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public Boolean getFontStyleItalic(XWPFRun run) {
        return (Boolean)RunFontStyleItalicValueProvider.INSTANCE.getValue(run, this);
    }

    public Boolean getFontStyleItalic(CTRPr rPr) {
        return RunFontStyleItalicValueProvider.INSTANCE.getValue(rPr, this);
    }

    public Boolean getFontStyleItalic(CTR run, CTP paragraph) {
        return (Boolean)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontStyleItalicValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public Boolean getFontStyleStrike(XWPFRun run) {
        return (Boolean)RunFontStyleStrikeValueProvider.INSTANCE.getValue(run, this);
    }

    public Boolean getFontStyleStrike(CTRPr rPr) {
        return RunFontStyleStrikeValueProvider.INSTANCE.getValue(rPr, this);
    }

    public Boolean getFontStyleStrike(CTR run, CTP paragraph) {
        return (Boolean)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontStyleStrikeValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public Color getFontColor(XWPFRun run) {
        return (Color)RunFontColorValueProvider.INSTANCE.getValue(run, this);
    }

    public Color getFontColor(CTRPr rPr) {
        return RunFontColorValueProvider.INSTANCE.getValue(rPr, this);
    }

    public Color getFontColor(CTR run, CTP paragraph) {
        return (Color)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunFontColorValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public UnderlinePatterns getUnderline(CTRPr rPr) {
        return RunUnderlineValueProvider.INSTANCE.getValue(rPr, this);
    }

    public UnderlinePatterns getUnderline(XWPFRun run) {
        return (UnderlinePatterns)RunUnderlineValueProvider.INSTANCE.getValue(run, this);
    }

    public UnderlinePatterns getUnderline(CTR run, CTP paragraph) {
        return (UnderlinePatterns)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunUnderlineValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public Color getBackgroundColor(XWPFRun run) {
        return (Color)RunBackgroundColorValueProvider.INSTANCE.getValue(run, this);
    }

    public Color getBackgroundColor(CTRPr rPr) {
        return RunBackgroundColorValueProvider.INSTANCE.getValue(rPr, this);
    }

    public Color getBackgroundColor(CTR run, CTP paragraph) {
        return (Color)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunBackgroundColorValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public Color getTextHighlighting(XWPFRun run) {
        return (Color)RunTextHighlightingValueProvider.INSTANCE.getValue(run, this);
    }

    public Color getTextHighlighting(CTRPr rPr) {
        return RunTextHighlightingValueProvider.INSTANCE.getValue(rPr, this);
    }

    public Color getTextHighlighting(CTR run, CTP paragraph) {
        return (Color)org.apache.poi.xwpf.converter.core.openxmlformats.styles.run.RunTextHighlightingValueProvider.INSTANCE.getValue(run, paragraph, this);
    }

    public TableWidth getTableWidth(XWPFTable table) {
        return (TableWidth)TableWidthValueProvider.INSTANCE.getValue(table, this);
    }

    public TableWidth getTableWidth(CTTblPr tblPr) {
        return TableWidthValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableWidth getTableWidth(CTTblPrBase tblPr) {
        return TableWidthValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableWidth getTableWidth(CTTbl table) {
        return (TableWidth)org.apache.poi.xwpf.converter.core.openxmlformats.styles.table.TableWidthValueProvider.INSTANCE.getValue(table, this);
    }

    public ParagraphAlignment getTableAlignment(XWPFTable table) {
        return (ParagraphAlignment)TableAlignmentValueProvider.INSTANCE.getValue(table, this);
    }

    public ParagraphAlignment getTableAlignment(CTTblPr tblPr) {
        return TableAlignmentValueProvider.INSTANCE.getValue(tblPr);
    }

    public ParagraphAlignment getTableAlignment(CTTblPrBase tblPr) {
        return TableAlignmentValueProvider.INSTANCE.getValue(tblPr);
    }

    public ParagraphAlignment getTableAlignment(CTTbl table) {
        return (ParagraphAlignment)org.apache.poi.xwpf.converter.core.openxmlformats.styles.table.TableAlignmentValueProvider.INSTANCE.getValue(table, this);
    }

    public Float getTableIndentation(XWPFTable table) {
        return (Float)TableIndentationValueProvider.INSTANCE.getValue(table, this);
    }

    public Float getTableIndentation(CTTblPr tblPr) {
        return TableIndentationValueProvider.INSTANCE.getValue(tblPr);
    }

    public Float getTableIndentation(CTTblPrBase tblPr) {
        return TableIndentationValueProvider.INSTANCE.getValue(tblPr);
    }

    public Float getTableIndentation(CTTbl table) {
        return (Float)org.apache.poi.xwpf.converter.core.openxmlformats.styles.table.TableIndentationValueProvider.INSTANCE.getValue(table, this);
    }

    public TableCellBorder getTableBorderTop(XWPFTable table) {
        return (TableCellBorder)TableBorderTopValueProvider.INSTANCE.getValue(table, this);
    }

    public TableCellBorder getTableBorderTop(CTTblPr tblPr) {
        return TableBorderTopValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderTop(CTTblPrBase tblPr) {
        return TableBorderTopValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderBottom(XWPFTable table) {
        return (TableCellBorder)TableBorderBottomValueProvider.INSTANCE.getValue(table, this);
    }

    public TableCellBorder getTableBorderBottom(CTTblPr tblPr) {
        return TableBorderBottomValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderBottom(CTTblPrBase tblPr) {
        return TableBorderBottomValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderLeft(XWPFTable table) {
        return (TableCellBorder)TableBorderLeftValueProvider.INSTANCE.getValue(table, this);
    }

    public TableCellBorder getTableBorderLeft(CTTblPr tblPr) {
        return TableBorderLeftValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderLeft(CTTblPrBase tblPr) {
        return TableBorderLeftValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderRight(XWPFTable table) {
        return (TableCellBorder)TableBorderRightValueProvider.INSTANCE.getValue(table, this);
    }

    public TableCellBorder getTableBorderRight(CTTblPr tblPr) {
        return TableBorderRightValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderRight(CTTblPrBase tblPr) {
        return TableBorderRightValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderInsideH(XWPFTable table) {
        return (TableCellBorder)TableBorderInsideHValueProvider.INSTANCE.getValue(table, this);
    }

    public TableCellBorder getTableBorderInsideH(CTTblPr tblPr) {
        return TableBorderInsideHValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderInsideH(CTTblPrBase tblPr) {
        return TableBorderInsideHValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderInsideV(XWPFTable table) {
        return (TableCellBorder)TableBorderInsideVValueProvider.INSTANCE.getValue(table, this);
    }

    public TableCellBorder getTableBorderInsideV(CTTblPr tblPr) {
        return TableBorderInsideVValueProvider.INSTANCE.getValue(tblPr);
    }

    public TableCellBorder getTableBorderInsideV(CTTblPrBase tblPr) {
        return TableBorderInsideVValueProvider.INSTANCE.getValue(tblPr);
    }

    public Float getTableMarginTop(XWPFTable table) {
        return (Float)TableMarginTopValueProvider.INSTANCE.getValue(table, this);
    }

    public Float getTableMarginTop(CTTblPrBase tcPr) {
        return TableMarginTopValueProvider.INSTANCE.getValue(tcPr);
    }

    public Float getTableMarginBottom(XWPFTable table) {
        return (Float)TableMarginBottomValueProvider.INSTANCE.getValue(table, this);
    }

    public Float getTableMarginBottom(CTTblPrBase tcPr) {
        return TableMarginBottomValueProvider.INSTANCE.getValue(tcPr);
    }

    public Float getTableMarginLeft(XWPFTable table) {
        return (Float)TableMarginLeftValueProvider.INSTANCE.getValue(table, this);
    }

    public Float getTableMarginLeft(CTTblPrBase tcPr) {
        return TableMarginLeftValueProvider.INSTANCE.getValue(tcPr);
    }

    public Float getTableMarginRight(XWPFTable table) {
        return (Float)TableMarginRightValueProvider.INSTANCE.getValue(table, this);
    }

    public Float getTableMarginRight(CTTblPrBase tcPr) {
        return TableMarginRightValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableHeight getTableRowHeight(XWPFTableRow row) {
        return (TableHeight)TableRowHeightValueProvider.INSTANCE.getValue(row, this);
    }

    public TableHeight getTableRowHeight(CTTrPr trPr) {
        return TableRowHeightValueProvider.INSTANCE.getValue(trPr);
    }

    public Float getTableRowMarginTop(XWPFTableRow row) {
        return (Float)TableRowMarginTopValueProvider.INSTANCE.getValue(row, this);
    }

    public Float getTableRowMarginTop(CTTblPrEx tblPrEx) {
        return TableRowMarginTopValueProvider.INSTANCE.getValue(tblPrEx);
    }

    public Float getTableRowMarginBottom(XWPFTableRow row) {
        return (Float)TableRowMarginBottomValueProvider.INSTANCE.getValue(row, this);
    }

    public Float getTableRowMarginBottom(CTTblPrEx tblPrEx) {
        return TableRowMarginBottomValueProvider.INSTANCE.getValue(tblPrEx);
    }

    public Float getTableRowMarginLeft(XWPFTableRow row) {
        return (Float)TableRowMarginLeftValueProvider.INSTANCE.getValue(row, this);
    }

    public Float getTableRowMarginLeft(CTTblPrEx tblPrEx) {
        return TableRowMarginLeftValueProvider.INSTANCE.getValue(tblPrEx);
    }

    public Float getTableRowMarginRight(XWPFTableRow row) {
        return (Float)TableRowMarginRightValueProvider.INSTANCE.getValue(row, this);
    }

    public Float getTableRowMarginRight(CTTblPrEx tblPrEx) {
        return TableRowMarginRightValueProvider.INSTANCE.getValue(tblPrEx);
    }

    public boolean isTableRowHeader(XWPFTableRow row) {
        return (Boolean)TableRowHeaderValueProvider.INSTANCE.getValue(row, this);
    }

    public boolean isTableRowHeader(CTRow row) {
        return org.apache.poi.xwpf.converter.core.openxmlformats.styles.table.row.TableRowHeaderValueProvider.INSTANCE.getValue(row, this);
    }

    public STVerticalJc.Enum getTableCellVerticalAlignment(XWPFTableCell cell) {
        return (STVerticalJc.Enum)TableCellVerticalAlignmentValueProvider.INSTANCE.getValue(cell, this);
    }

    public Color getTableCellBackgroundColor(XWPFTableCell cell) {
        return (Color)TableCellBackgroundColorValueProvider.INSTANCE.getValue(cell, this);
    }

    public Color getTableCellBackgroundColor(CTTcPr tcPr) {
        return TableCellBackgroundColorValueProvider.INSTANCE.getValue(tcPr);
    }

    public Color getTableCellBackgroundColor(CTTc cell) {
        return (Color)org.apache.poi.xwpf.converter.core.openxmlformats.styles.table.cell.TableCellBackgroundColorValueProvider.INSTANCE.getValue(cell, this);
    }

    public BigInteger getTableCellGridSpan(XWPFTableCell cell) {
        return (BigInteger)TableCellGridSpanValueProvider.INSTANCE.getValue(cell, this);
    }

    public BigInteger getTableCellGridSpan(CTTcPr tcPr) {
        return TableCellGridSpanValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableWidth getTableCellWith(XWPFTableCell cell) {
        return (TableWidth)TableCellWidthValueProvider.INSTANCE.getValue(cell, this);
    }

    public TableWidth getTableCellWith(CTTcPr tcPr) {
        return TableCellWidthValueProvider.INSTANCE.getValue(tcPr);
    }

    public CTTextDirection getTextDirection(XWPFTableCell cell) {
        return (CTTextDirection)TableCellTextDirectionValueProvider.INSTANCE.getValue(cell, this);
    }

    public CTTextDirection getTextDirection(CTTcPr tcPr) {
        return TableCellTextDirectionValueProvider.INSTANCE.getValue(tcPr);
    }

    public STMerge.Enum getTableCellVMerge(XWPFTableCell cell) {
        return (STMerge.Enum)TableCellVMergeValueProvider.INSTANCE.getValue(cell, this);
    }

    public STMerge.Enum getTableCellVMerge(CTTcPr tcPr) {
        return TableCellVMergeValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableCellBorder getTableCellBorderWithConflicts(XWPFTableCell cell, BorderSide borderSide) {
        TableCellBorder border = this.getTableCellBorder(cell, borderSide);
        if (border == null) {
            XWPFTable table = cell.getTableRow().getTable();
            boolean borderInside = this.isBorderInside(cell, borderSide);
            if (borderInside && (border = this.getTableCellBorderInside(cell, borderSide)) == null) {
                border = this.getTableBorderInside(table, borderSide);
            }
            if (border == null && !borderInside) {
                border = this.getTableBorder(table, borderSide);
            }
        }
        return border;
    }

    public boolean isBorderInside(XWPFTableCell cell, BorderSide borderSide) {
        TableCellInfo cellInfo = this.getTableCellInfo(cell);
        boolean borderInside = cellInfo.isInside(borderSide);
        return borderInside;
    }

    public TableCellBorder getTableBorder(XWPFTable table, BorderSide borderSide) {
        switch (borderSide) {
            case TOP: {
                return this.getTableBorderTop(table);
            }
            case BOTTOM: {
                return this.getTableBorderBottom(table);
            }
            case LEFT: {
                return this.getTableBorderLeft(table);
            }
            case RIGHT: {
                return this.getTableBorderRight(table);
            }
        }
        return null;
    }

    public TableCellBorder getTableBorderInside(XWPFTable table, BorderSide borderSide) {
        switch (borderSide) {
            case TOP: 
            case BOTTOM: {
                return this.getTableBorderInsideH(table);
            }
        }
        return this.getTableBorderInsideV(table);
    }

    public TableCellBorder getTableCellBorderInside(XWPFTableCell cell, BorderSide borderSide) {
        switch (borderSide) {
            case TOP: 
            case BOTTOM: {
                return this.getTableCellBorderInsideH(cell);
            }
        }
        return this.getTableCellBorderInsideV(cell);
    }

    public TableCellBorder getTableCellBorder(XWPFTableCell cell, BorderSide borderSide) {
        switch (borderSide) {
            case TOP: {
                return this.getTableCellBorderTop(cell);
            }
            case BOTTOM: {
                return this.getTableCellBorderBottom(cell);
            }
            case LEFT: {
                return this.getTableCellBorderLeft(cell);
            }
            case RIGHT: {
                return this.getTableCellBorderRight(cell);
            }
        }
        return null;
    }

    public TableCellBorder getTableCellBorderTop(XWPFTableCell cell) {
        return (TableCellBorder)TableCellBorderTopValueProvider.INSTANCE.getValue(cell, this);
    }

    public TableCellBorder getTableCellBorderTop(CTTcPr tcPr) {
        return TableCellBorderTopValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableCellBorder getTableCellBorderBottom(XWPFTableCell cell) {
        return (TableCellBorder)TableCellBorderBottomValueProvider.INSTANCE.getValue(cell, this);
    }

    public TableCellBorder getTableCellBorderBottom(CTTcPr tcPr) {
        return TableCellBorderBottomValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableCellBorder getTableCellBorderLeft(XWPFTableCell cell) {
        return (TableCellBorder)TableCellBorderLeftValueProvider.INSTANCE.getValue(cell, this);
    }

    public TableCellBorder getTableCellBorderLeft(CTTcPr tcPr) {
        return TableCellBorderLeftValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableCellBorder getTableCellBorderRight(XWPFTableCell cell) {
        return (TableCellBorder)TableCellBorderRightValueProvider.INSTANCE.getValue(cell, this);
    }

    public TableCellBorder getTableCellBorderRight(CTTcPr tcPr) {
        return TableCellBorderRightValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableCellBorder getTableCellBorderInsideH(XWPFTableCell cell) {
        return (TableCellBorder)TableCellBorderInsideHValueProvider.INSTANCE.getValue(cell, this);
    }

    public TableCellBorder getTableCellBorderInsideH(CTTcPr tcPr) {
        return TableCellBorderInsideHValueProvider.INSTANCE.getValue(tcPr);
    }

    public TableCellBorder getTableCellBorderInsideV(XWPFTableCell cell) {
        return (TableCellBorder)TableCellBorderInsideVValueProvider.INSTANCE.getValue(cell, this);
    }

    public TableCellBorder getTableCellBorderInsideV(CTTcPr tcPr) {
        return TableCellBorderInsideVValueProvider.INSTANCE.getValue(tcPr);
    }

    public Float getTableCellMarginTop(XWPFTableCell cell) {
        return (Float)TableCellMarginTopValueProvider.INSTANCE.getValue(cell, this);
    }

    public Float getTableCellMarginTop(CTTcPr tcPr) {
        return TableCellMarginTopValueProvider.INSTANCE.getValue(tcPr);
    }

    public Float getTableCellMarginBottom(XWPFTableCell cell) {
        return (Float)TableCellMarginBottomValueProvider.INSTANCE.getValue(cell, this);
    }

    public Float getTableCellMarginBottom(CTTcPr tcPr) {
        return TableCellMarginBottomValueProvider.INSTANCE.getValue(tcPr);
    }

    public Float getTableCellMarginLeft(XWPFTableCell cell) {
        return (Float)TableCellMarginLeftValueProvider.INSTANCE.getValue(cell, this);
    }

    public Float getTableCellMarginLeft(CTTcPr tcPr) {
        return TableCellMarginLeftValueProvider.INSTANCE.getValue(tcPr);
    }

    public Float getTableCellMarginRight(XWPFTableCell cell) {
        return (Float)TableCellMarginRightValueProvider.INSTANCE.getValue(cell, this);
    }

    public Float getTableCellMarginRight(CTTcPr tcPr) {
        return TableCellMarginRightValueProvider.INSTANCE.getValue(tcPr);
    }

    public Boolean getTableCellNoWrap(XWPFTableCell cell) {
        return (Boolean)TableCellNoWrapValueProvider.INSTANCE.getValue(cell, this);
    }

    public Boolean getTableCellNoWrap(CTTcPr tcPr) {
        return TableCellNoWrapValueProvider.INSTANCE.getValue(tcPr);
    }

    public CTStyle getDefaultCharacterStyle() {
        return this.defaultCharacterStyle;
    }

    public CTStyle getDefaultNumberingStyle() {
        return this.defaultNumberingStyle;
    }

    public CTStyle getDefaultTableStyle() {
        return this.defaultTableStyle;
    }

    public CTStyle getStyle(CTString basedOn) {
        if (basedOn == null) {
            return null;
        }
        return this.getStyle(basedOn.getVal());
    }

    public <T> T getValue(String key) {
        return (T)this.values.get(key);
    }

    public <T> void setValue(String key, T value) {
        this.values.put(key, value);
    }

    public TableCellInfo getTableCellInfo(XWPFTableCell cell) {
        XWPFTable table = cell.getTableRow().getTable();
        return this.getTableInfo(table).getCellInfo(cell);
    }

    public TableInfo getTableInfo(XWPFTable table) {
        TableInfo tableInfo;
        if (this.tableInfos == null) {
            this.tableInfos = new HashMap<XWPFTable, TableInfo>();
        }
        if ((tableInfo = this.tableInfos.get(table)) == null) {
            tableInfo = new TableInfo(table, this);
            this.tableInfos.put(table, tableInfo);
        }
        return tableInfo;
    }

    public CTTblStylePr getTableStyle(String tableStyleID, STTblStyleOverrideType.Enum type) {
        CTStyle style = this.getStyle(tableStyleID);
        if (style == null) {
            return null;
        }
        List tblStylePrs = style.getTblStylePrList();
        for (CTTblStylePr tblStylePr : tblStylePrs) {
            if (!type.equals(tblStylePr.getType())) continue;
            return tblStylePr;
        }
        return null;
    }

    public float getDefaultTabStop() {
        if (this.defaultTabStop == null) {
            CTTwipsMeasure value;
            CTSettings settings = this.getCTSettings();
            if (settings != null && (value = settings.getDefaultTabStop()) != null && !value.isNil()) {
                this.defaultTabStop = Float.valueOf(DxaUtil.dxa2points(value.getVal()));
            }
            if (this.defaultTabStop == null) {
                this.defaultTabStop = Float.valueOf(DEFAULT_TAB_STOP_POINT);
            }
        }
        return this.defaultTabStop.floatValue();
    }

    public CTSettings getCTSettings() {
        return this.ctSettings;
    }

    private static CTSettings getCTSettings(XWPFDocument document) {
        XWPFSettings settings = XWPFStylesDocument.getSettings(document);
        if (settings != null) {
            try {
                InputStream inputStream = settings.getPackagePart().getInputStream();
                return SettingsDocument.Factory.parse((InputStream)inputStream).getSettings();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static XWPFSettings getSettings(XWPFDocument document) {
        for (POIXMLDocumentPart p : document.getRelations()) {
            String relationshipType = p.getPackageRelationship().getRelationshipType();
            if (!relationshipType.equals(XWPFRelation.SETTINGS.getRelation())) continue;
            return (XWPFSettings)p;
        }
        return null;
    }

    public List<ThemeDocument> getThemeDocuments() {
        return this.themeDocuments;
    }

    private static List<ThemeDocument> getThemeDocuments(XWPFDocument document) {
        ArrayList<ThemeDocument> themeDocuments = new ArrayList<ThemeDocument>();
        for (POIXMLDocumentPart p : document.getRelations()) {
            String relationshipType = p.getPackageRelationship().getRelationshipType();
            if (!"http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme".equals(relationshipType)) continue;
            try {
                InputStream inputStream = p.getPackagePart().getInputStream();
                ThemeDocument theme = ThemeDocument.Factory.parse((InputStream)inputStream);
                themeDocuments.add(theme);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return themeDocuments;
    }

    private static List<FontsDocument> getFontsDocument(XWPFDocument document) {
        ArrayList<FontsDocument> fontsDocuments = new ArrayList<FontsDocument>();
        for (POIXMLDocumentPart p : document.getRelations()) {
            String relationshipType = p.getPackageRelationship().getRelationshipType();
            if (!XWPFRelation.FONT_TABLE.getRelation().equals(relationshipType)) continue;
            try {
                InputStream inputStream = p.getPackagePart().getInputStream();
                FontsDocument fontsDocument = FontsDocument.Factory.parse((InputStream)inputStream);
                fontsDocuments.add(fontsDocument);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fontsDocuments;
    }

    public List<String> getFontsAltName(String fontName) throws Exception {
        return this.fontsAltName.get(fontName);
    }

    public String getFontNameToUse(String fontName) {
        return this.fontsToUse.get(fontName);
    }

    public void setFontNameToUse(String fontName, String altFfontName) {
        this.fontsToUse.put(fontName, altFfontName);
    }
}

