/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.clustering.BatchClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.ClusterToClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.hierarchy.BatchHierarchicalClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.hierarchy.BinaryClusterHierarchyNode;
import gov.sandia.cognition.learning.algorithm.clustering.hierarchy.ClusterHierarchyNode;
import gov.sandia.cognition.learning.algorithm.clustering.hierarchy.DefaultClusterHierarchyNode;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=true, comments={"I *really* don't like the use of 'continue', but I will defer.", "Please implement the sections previously marked as 'to do'"}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2008-10-07", moreChangesNeeded=false, comments={"The clusterer now supports hierarchical clustering."})})
public class AgglomerativeClusterer<DataType, ClusterType extends Cluster<DataType>>
extends AbstractAnytimeBatchLearner<Collection<? extends DataType>, Collection<ClusterType>>
implements BatchClusterer<DataType, ClusterType>,
BatchHierarchicalClusterer<DataType, ClusterType> {
    public static final int DEFAULT_MIN_NUM_CLUSTERS = 1;
    public static final double DEFAULT_MAX_MIN_DISTANCE = Double.MAX_VALUE;
    public static final int DEFAULT_MAX_ITERATIONS = Integer.MAX_VALUE;
    protected ClusterToClusterDivergenceFunction<ClusterType, DataType> divergenceFunction;
    protected ClusterCreator<ClusterType, DataType> creator;
    protected int minNumClusters;
    protected double maxMinDistance;
    protected ArrayList<ClusterType> clusters;
    protected ArrayList<HierarchyNode<DataType, ClusterType>> clustersHierarchy;
    protected transient ArrayList<Double> minDistances;
    protected transient ArrayList<Integer> minClusters;

    public AgglomerativeClusterer() {
        this(null, null);
    }

    public AgglomerativeClusterer(ClusterToClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator) {
        this(divergenceFunction, creator, 1);
    }

    public AgglomerativeClusterer(ClusterToClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator, int minNumClusters) {
        this(divergenceFunction, creator, minNumClusters, Double.MAX_VALUE);
    }

    public AgglomerativeClusterer(ClusterToClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator, double maxMinDistance) {
        this(divergenceFunction, creator, 1, maxMinDistance);
    }

    public AgglomerativeClusterer(ClusterToClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator, int minNumClusters, double maxMinDistance) {
        super(Integer.MAX_VALUE);
        this.setDivergenceFunction(divergenceFunction);
        this.setCreator(creator);
        this.setMinNumClusters(minNumClusters);
        this.setMaxMinDistance(maxMinDistance);
        this.setClusters(null);
        this.setClustersHierarchy(null);
        this.setMinDistances(null);
        this.setMinClusters(null);
    }

    @Override
    public AgglomerativeClusterer<DataType, ClusterType> clone() {
        AgglomerativeClusterer result = (AgglomerativeClusterer)super.clone();
        result.divergenceFunction = (ClusterToClusterDivergenceFunction)ObjectUtil.cloneSafe(this.divergenceFunction);
        result.creator = (ClusterCreator)ObjectUtil.cloneSafe(this.creator);
        result.clusters = null;
        result.clustersHierarchy = null;
        result.minDistances = null;
        result.minClusters = null;
        return result;
    }

    @Override
    public ClusterHierarchyNode<DataType, ClusterType> clusterHierarchically(Collection<? extends DataType> data) {
        int tempMinNumClusters = this.getMinNumClusters();
        double tempMaxMinDistance = this.getMaxMinDistance();
        this.setMinNumClusters(1);
        this.setMaxMinDistance(Double.MAX_VALUE);
        this.learn(data);
        this.setMinNumClusters(tempMinNumClusters);
        this.setMaxMinDistance(tempMaxMinDistance);
        if (CollectionUtil.isEmpty(this.clustersHierarchy)) {
            return null;
        }
        if (this.clustersHierarchy.size() == 1) {
            return this.clustersHierarchy.get(0);
        }
        DefaultClusterHierarchyNode root = new DefaultClusterHierarchyNode();
        root.setChildren(new ArrayList(this.clustersHierarchy));
        return root;
    }

    @Override
    protected boolean initializeAlgorithm() {
        int numElements = ((Collection)this.data).size();
        this.setClusters(new ArrayList(numElements));
        this.setClustersHierarchy(new ArrayList<HierarchyNode<DataType, ClusterType>>(numElements));
        this.setMinDistances(new ArrayList<Double>(numElements));
        this.setMinClusters(new ArrayList<Integer>(numElements));
        for (Object element : (Collection)this.data) {
            LinkedList singleton = new LinkedList();
            singleton.add(element);
            ClusterType cluster = this.creator.createCluster(singleton);
            this.clusters.add(cluster);
            this.clustersHierarchy.add(new HierarchyNode(cluster));
            this.minDistances.add((Double)Double.MAX_VALUE);
            this.minClusters.add(-1);
        }
        for (int i = 0; i < this.getNumClusters(); ++i) {
            this.updateMinDistance(i);
        }
        return true;
    }

    @Override
    protected boolean step() {
        if (this.getNumClusters() <= this.minNumClusters) {
            return false;
        }
        double minDistance = Double.MAX_VALUE;
        int minFrom = -1;
        int minTo = -1;
        for (int i = 0; i < this.getNumClusters(); ++i) {
            double distance = this.minDistances.get(i);
            if (minFrom >= 0 && !(distance < minDistance)) continue;
            minDistance = distance;
            minFrom = i;
            minTo = this.minClusters.get(i);
        }
        if (minDistance > this.maxMinDistance) {
            return false;
        }
        int mergedIndex = this.mergeClusters(minFrom, minTo, minDistance);
        Cluster merged = (Cluster)this.clusters.get(mergedIndex);
        this.updateMinDistance(mergedIndex);
        for (int i = 0; i < this.getNumClusters(); ++i) {
            Cluster other = (Cluster)this.clusters.get(i);
            if (other == merged) continue;
            int minClusterIndex = this.minClusters.get(i);
            if (minClusterIndex == minTo || minClusterIndex == minFrom) {
                this.updateMinDistance(i);
                continue;
            }
            double distance = this.divergenceFunction.evaluate(other, merged);
            if (!(distance < this.minDistances.get(i))) continue;
            this.minDistances.set(i, distance);
            this.minClusters.set(i, mergedIndex);
        }
        return this.getNumClusters() > this.minNumClusters;
    }

    @Override
    protected void cleanupAlgorithm() {
        this.setMinDistances(null);
        this.setMinClusters(null);
    }

    protected void updateMinDistance(int index) {
        Cluster cluster = (Cluster)this.clusters.get(index);
        double minDistance = Double.MAX_VALUE;
        int minCluster = -1;
        for (int i = 0; i < this.getNumClusters(); ++i) {
            Cluster other = (Cluster)this.clusters.get(i);
            if (cluster == other) continue;
            double distance = this.divergenceFunction.evaluate(cluster, other);
            if (minCluster >= 0 && !(distance < minDistance)) continue;
            minDistance = distance;
            minCluster = i;
        }
        this.minDistances.set(index, minDistance);
        this.minClusters.set(index, minCluster);
    }

    protected int mergeClusters(int firstIndex, int secondIndex, double distance) {
        Cluster first = (Cluster)this.clusters.get(firstIndex);
        Cluster second = (Cluster)this.clusters.get(secondIndex);
        int minIndex = Math.min(firstIndex, secondIndex);
        int maxIndex = Math.max(firstIndex, secondIndex);
        ArrayList members = new ArrayList();
        members.addAll(first.getMembers());
        members.addAll(second.getMembers());
        ClusterType merged = this.creator.createCluster(members);
        HierarchyNode<DataType, ClusterType> firstChild = this.clustersHierarchy.get(firstIndex);
        HierarchyNode<DataType, ClusterType> secondChild = this.clustersHierarchy.get(secondIndex);
        HierarchyNode<DataType, ClusterType> parent = new HierarchyNode<DataType, ClusterType>(merged, firstChild, secondChild, distance);
        int endClusterNum = this.clusters.size() - 1;
        if (endClusterNum != maxIndex) {
            Cluster endCluster = (Cluster)this.clusters.get(endClusterNum);
            this.clusters.set(maxIndex, endCluster);
            this.minDistances.set(maxIndex, this.minDistances.get(endClusterNum));
            this.minClusters.set(maxIndex, this.minClusters.get(endClusterNum));
            for (int i = 0; i < this.getNumClusters(); ++i) {
                if (endClusterNum != this.minClusters.get(i)) continue;
                this.minClusters.set(i, maxIndex);
            }
        }
        int newIndex = minIndex;
        this.clusters.set(newIndex, merged);
        this.clustersHierarchy.set(newIndex, parent);
        this.minDistances.set(newIndex, (Double)Double.MAX_VALUE);
        this.minClusters.set(newIndex, null);
        this.clusters.remove(endClusterNum);
        this.clustersHierarchy.remove(endClusterNum);
        this.minDistances.remove(endClusterNum);
        this.minClusters.remove(endClusterNum);
        return newIndex;
    }

    public ArrayList<ClusterType> getResult() {
        return this.clusters;
    }

    public int getNumClusters() {
        if (this.clusters == null) {
            return 0;
        }
        return this.clusters.size();
    }

    public ClusterToClusterDivergenceFunction<ClusterType, DataType> getDivergenceFunction() {
        return this.divergenceFunction;
    }

    public void setDivergenceFunction(ClusterToClusterDivergenceFunction<ClusterType, DataType> divergenceFunction) {
        this.divergenceFunction = divergenceFunction;
    }

    public ClusterCreator<ClusterType, DataType> getCreator() {
        return this.creator;
    }

    public void setCreator(ClusterCreator<ClusterType, DataType> creator) {
        this.creator = creator;
    }

    public int getMinNumClusters() {
        return this.minNumClusters;
    }

    public void setMinNumClusters(int minNumClusters) {
        this.minNumClusters = Math.max(1, minNumClusters);
    }

    public double getMaxMinDistance() {
        return this.maxMinDistance;
    }

    public void setMaxMinDistance(double maxMinDistance) {
        this.maxMinDistance = maxMinDistance;
    }

    protected void setClusters(ArrayList<ClusterType> clusters) {
        this.clusters = clusters;
    }

    public ArrayList<HierarchyNode<DataType, ClusterType>> getClustersHierarchy() {
        return this.clustersHierarchy;
    }

    protected void setClustersHierarchy(ArrayList<HierarchyNode<DataType, ClusterType>> clustersHierarchy) {
        this.clustersHierarchy = clustersHierarchy;
    }

    protected void setMinDistances(ArrayList<Double> minDistances) {
        this.minDistances = minDistances;
    }

    protected void setMinClusters(ArrayList<Integer> minClusters) {
        this.minClusters = minClusters;
    }

    public static class HierarchyNode<DataType, ClusterType extends Cluster<DataType>>
    extends BinaryClusterHierarchyNode<DataType, ClusterType> {
        protected double childrenDivergence;

        public HierarchyNode() {
            this(null);
        }

        public HierarchyNode(ClusterType cluster) {
            this(cluster, null, null, 0.0);
        }

        public HierarchyNode(ClusterType cluster, HierarchyNode<DataType, ClusterType> firstChild, HierarchyNode<DataType, ClusterType> secondChild, double childrenDivergence) {
            super(cluster, firstChild, secondChild);
            this.setChildrenDivergence(childrenDivergence);
        }

        public double getChildrenDivergence() {
            return this.childrenDivergence;
        }

        public void setChildrenDivergence(double childrenDivergence) {
            this.childrenDivergence = childrenDivergence;
        }
    }
}

