/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.cluster;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.CentroidCluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.IncrementalClusterCreator;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Code generally looks fine."})
public class VectorMeanCentroidClusterCreator
extends AbstractCloneableSerializable
implements IncrementalClusterCreator<CentroidCluster<Vector>, Vector> {
    public static final VectorMeanCentroidClusterCreator INSTANCE = new VectorMeanCentroidClusterCreator();

    @Override
    public CentroidCluster<Vector> createCluster() {
        return new CentroidCluster<Object>(null, new ArrayList());
    }

    @Override
    public CentroidCluster<Vector> createCluster(Collection<Vector> members) {
        if (members.size() <= 0) {
            return new CentroidCluster<Vector>(null, members);
        }
        Vector centroid = null;
        for (Vector member : members) {
            if (centroid == null) {
                centroid = member.clone();
                continue;
            }
            centroid.plusEquals((Ring)member);
        }
        centroid.scaleEquals(1.0 / (double)members.size());
        return new CentroidCluster<Vector>(centroid, members);
    }

    @Override
    public void addClusterMember(CentroidCluster<Vector> cluster, Vector member) {
        Vector centroid = cluster.getCentroid();
        if (centroid == null) {
            centroid = member.clone();
            cluster.setCentroid(centroid);
        } else {
            int oldSize = ((ArrayList)cluster.getMembers()).size();
            int newSize = oldSize + 1;
            Vector delta = (Vector)member.minus((Ring)centroid);
            delta.scaleEquals(1.0 / (double)newSize);
            centroid.plusEquals((Ring)delta);
        }
        ((ArrayList)cluster.getMembers()).add(member);
    }

    @Override
    public boolean removeClusterMember(CentroidCluster<Vector> cluster, Vector member) {
        if (((ArrayList)cluster.getMembers()).remove(member)) {
            int newSize = ((ArrayList)cluster.getMembers()).size();
            Vector centroid = cluster.getCentroid();
            if (newSize <= 0) {
                centroid.zero();
            } else {
                Vector delta = (Vector)member.minus((Ring)centroid);
                delta.scaleEquals(1.0 / (double)newSize);
                centroid.minusEquals((Ring)delta);
            }
            return true;
        }
        return false;
    }
}

