/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.genetic.reproducer;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.genetic.EvaluatedGenome;
import gov.sandia.cognition.learning.algorithm.genetic.reproducer.CrossoverFunction;
import gov.sandia.cognition.learning.algorithm.genetic.reproducer.Reproducer;
import gov.sandia.cognition.learning.algorithm.genetic.selector.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"This class still has open task from last code review, but I suspect it's due to lack of interest.", "Moved previous code review to CodeReview annotation", "Otherwise, looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-04", changesNeeded=false, comments={"Class looks fine.", "It may want to include some randomness in case the selector that it calls is deterministic and returns the same population twice."})})
public class CrossoverReproducer<GenomeType>
implements Reproducer<GenomeType> {
    private Selector<GenomeType> selector;
    private CrossoverFunction<GenomeType> crossoverFunction;

    public CrossoverReproducer(Selector<GenomeType> selector, CrossoverFunction<GenomeType> crossoverFunction) {
        this.setSelector(selector);
        this.setCrossoverFunction(crossoverFunction);
    }

    @Override
    public ArrayList<GenomeType> reproduce(Collection<EvaluatedGenome<GenomeType>> genomes) {
        Collection<EvaluatedGenome<GenomeType>> selectedGenomes1 = this.getSelector().select(genomes);
        Collection<EvaluatedGenome<GenomeType>> selectedGenomes2 = this.getSelector().select(genomes);
        int numGenomes = Math.min(selectedGenomes1.size(), selectedGenomes2.size());
        ArrayList<GenomeType> newGenomes = new ArrayList<GenomeType>(numGenomes);
        Iterator<EvaluatedGenome<GenomeType>> it1 = selectedGenomes1.iterator();
        Iterator<EvaluatedGenome<GenomeType>> it2 = selectedGenomes2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            GenomeType genome1 = it1.next().getGenome();
            GenomeType genome2 = it2.next().getGenome();
            GenomeType newGenome = this.getCrossoverFunction().crossover(genome1, genome2);
            newGenomes.add(newGenome);
        }
        return newGenomes;
    }

    public Selector<GenomeType> getSelector() {
        return this.selector;
    }

    public CrossoverFunction<GenomeType> getCrossoverFunction() {
        return this.crossoverFunction;
    }

    public void setSelector(Selector<GenomeType> selector) {
        this.selector = selector;
    }

    public void setCrossoverFunction(CrossoverFunction<GenomeType> crossoverFunction) {
        this.crossoverFunction = crossoverFunction;
    }
}

