/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.AbstractAnytimeFunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.DirectionalVectorToScalarFunction;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizerDerivativeFree;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.WeightedInputOutputPair;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.LinkedList;
import java.util.List;

@PublicationReferences(references={@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={87, 90}, notes={"Section 4.2"}), @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={417, 418}, notes={"Section 10.5"}, url="http://www.nrbook.com/a/bookcpdf.php")})
public class FunctionMinimizerDirectionSetPowell
extends AbstractAnytimeFunctionMinimizer<Vector, Double, Evaluator<? super Vector, Double>> {
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    public static final double DEFAULT_TOLERANCE = 1.0E-5;
    private static final double TOLERANCE_DELTA_X = 1.0E-7;
    public static final LineMinimizer<?> DEFAULT_LINE_MINIMIZER = new LineMinimizerDerivativeFree();
    private LineMinimizer<?> lineMinimizer;
    private List<Vector> directionSet;
    private DirectionalVectorToScalarFunction lineFunction;

    public FunctionMinimizerDirectionSetPowell() {
        this((LineMinimizer)ObjectUtil.cloneSafe(DEFAULT_LINE_MINIMIZER));
    }

    public FunctionMinimizerDirectionSetPowell(LineMinimizer<?> lineMinimizer) {
        this(lineMinimizer, null, 1.0E-5, 1000);
    }

    public FunctionMinimizerDirectionSetPowell(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(initialGuess, tolerance, maxIterations);
        this.setLineMinimizer(lineMinimizer);
    }

    @Override
    protected boolean initializeAlgorithm() {
        int numDimensions = ((Vector)this.initialGuess).getDimensionality();
        this.directionSet = new LinkedList<Vector>();
        for (int j = 0; j < numDimensions; ++j) {
            Vector dj = VectorFactory.getDefault().createVector(numDimensions);
            dj.setElement(j, 1.0);
            this.directionSet.add(dj);
        }
        double fx = (Double)((Evaluator)this.data).evaluate(this.initialGuess);
        this.result = new DefaultInputOutputPair<Object, Double>(this.initialGuess, fx);
        this.lineFunction = new DirectionalVectorToScalarFunction((Evaluator<? super Vector, ? extends Double>)((Evaluator)this.data), null, null);
        return true;
    }

    @Override
    protected boolean step() {
        double scale;
        WeightedInputOutputPair<Vector, Double> lineResult;
        int bestIndex = -1;
        double bestDecrease = Double.POSITIVE_INFINITY;
        Vector xoriginal = (Vector)this.result.getInput();
        double foriginal = (Double)this.result.getOutput();
        int index = 0;
        for (Vector direction : this.directionSet) {
            if (!this.getKeepGoing()) {
                return false;
            }
            Vector xold = (Vector)this.result.getInput();
            double fold = (Double)this.result.getOutput();
            this.lineFunction.setVectorOffset(xold);
            this.lineFunction.setDirection(direction);
            lineResult = this.lineMinimizer.minimizeAlongDirection(this.lineFunction, fold, null);
            scale = lineResult.getWeight();
            this.result = lineResult;
            double fnew = (Double)this.result.getOutput();
            double deltaj = fnew - fold;
            if (bestDecrease > deltaj) {
                bestDecrease = deltaj;
                bestIndex = index;
            }
            if (scale != 0.0) {
                direction.scaleEquals(scale);
            }
            ++index;
        }
        Vector xnew = (Vector)this.result.getInput();
        double fnew = (Double)this.result.getOutput();
        if (2.0 * Math.abs(foriginal - fnew) <= this.tolerance * (Math.abs(foriginal) + Math.abs(fnew))) {
            return false;
        }
        Vector direction = (Vector)xnew.minus((Ring)xoriginal);
        this.lineFunction.setVectorOffset(xnew);
        this.lineFunction.setDirection(direction);
        this.result = lineResult = this.lineMinimizer.minimizeAlongDirection(this.lineFunction, fnew, null);
        scale = lineResult.getWeight();
        double maximumDelta = 0.0;
        Vector delta = (Vector)((Vector)this.result.getInput()).minus((Ring)xoriginal);
        for (int i = 0; i < delta.getDimensionality(); ++i) {
            double normalizedX = Math.max(Math.abs(((Vector)this.result.getInput()).getElement(i)), 1.0);
            double deltaX = Math.abs(delta.getElement(i)) / normalizedX;
            if (!(maximumDelta < deltaX)) continue;
            maximumDelta = deltaX;
        }
        if (maximumDelta < 1.0E-7) {
            return false;
        }
        if (scale != 0.0) {
            direction.scaleEquals(scale);
            this.directionSet.remove(bestIndex);
            this.directionSet.add(direction);
        }
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    public LineMinimizer<?> getLineMinimizer() {
        return this.lineMinimizer;
    }

    public void setLineMinimizer(LineMinimizer<?> lineMinimizer) {
        this.lineMinimizer = lineMinimizer;
    }
}

