/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.AbstractAnytimeFunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.DirectionalVectorToScalarFunction;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.ArrayList;

@PublicationReferences(references={@PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={411, 412}, notes={"Section 10.5"}, url="http://www.nrbook.com/a/bookcpdf.php"), @PublicationReference(author={"Wikipedia"}, title="Nelder-Mead method", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Nelder-Mead_method")})
public class FunctionMinimizerNelderMead
extends AbstractAnytimeFunctionMinimizer<Vector, Double, Evaluator<? super Vector, Double>> {
    public static final double DEFAULT_TOLERANCE = 0.001;
    public static final int DEFAULT_MAX_ITERATIONS = 4000;
    private ArrayList<DefaultInputOutputPair<Vector, Double>> simplex;
    private Vector simplexInputSum;
    private static final double TINY = 1.0E-10;
    private DirectionalVectorToScalarFunction lineFunction;

    public FunctionMinimizerNelderMead() {
        super(null, 0.001, 4000);
    }

    @Override
    protected boolean initializeAlgorithm() {
        Evaluator f = (Evaluator)this.data;
        Vector x0 = ((Vector)this.getInitialGuess()).clone();
        Double y0 = (Double)f.evaluate((Object)x0);
        DefaultInputOutputPair<Vector, Double> p0 = new DefaultInputOutputPair<Vector, Double>(x0, y0);
        this.simplex = this.initializeSimplex(p0, 1.0);
        this.simplexInputSum = this.computeSimplexInputSum();
        this.result = null;
        this.lineFunction = new DirectionalVectorToScalarFunction((Evaluator<? super Vector, ? extends Double>)((Evaluator)this.data), null, null);
        return true;
    }

    public ArrayList<DefaultInputOutputPair<Vector, Double>> initializeSimplex(InputOutputPair<Vector, Double> initialPoint, double offsetValue) {
        Vector x0 = initialPoint.getInput();
        int M = x0.getDimensionality();
        ArrayList<DefaultInputOutputPair<Vector, Double>> localSimplex = new ArrayList<DefaultInputOutputPair<Vector, Double>>(M + 1);
        localSimplex.add(DefaultInputOutputPair.create(initialPoint.getInput(), initialPoint.getOutput()));
        for (int i = 0; i < M; ++i) {
            Vector xi = x0.clone();
            xi.setElement(i, x0.getElement(i) + offsetValue);
            Double yi = (Double)((Evaluator)this.data).evaluate((Object)xi);
            localSimplex.add(new DefaultInputOutputPair<Vector, Double>(xi, yi));
        }
        return localSimplex;
    }

    @Override
    protected boolean step() {
        double flow;
        int indexLow = 0;
        DefaultInputOutputPair<Vector, Double> pLow = this.simplex.get(indexLow);
        DefaultInputOutputPair<Vector, Double> pHigh = this.simplex.get(0);
        DefaultInputOutputPair<Vector, Double> pSecondHighest = null;
        for (int i = 1; i < this.simplex.size(); ++i) {
            DefaultInputOutputPair<Vector, Double> pi = this.simplex.get(i);
            if (pHigh.getOutput() < pi.getOutput()) {
                pSecondHighest = pHigh;
                pHigh = pi;
            } else if (pSecondHighest == null || pSecondHighest.getOutput() < pi.getOutput()) {
                pSecondHighest = pi;
            }
            if (!(pLow.getOutput() > pi.getOutput())) continue;
            pLow = pi;
            indexLow = i;
        }
        double fhigh = pHigh.getOutput();
        double rtol = 2.0 * Math.abs(fhigh - (flow = pLow.getOutput().doubleValue())) / (Math.abs(fhigh) + Math.abs(flow) + 1.0E-10);
        if (rtol <= this.getTolerance()) {
            return false;
        }
        this.result = pLow;
        DefaultInputOutputPair<Vector, Double> pnew = this.pointTry(pHigh, -1.0);
        if (pnew.getOutput() <= pLow.getOutput()) {
            pnew = this.pointTry(pHigh, 2.0);
            if (pnew.getOutput() <= pLow.getOutput()) {
                this.result = pnew;
            }
        } else if (pnew.getOutput() >= pSecondHighest.getOutput()) {
            double yHighSave = pHigh.getOutput();
            pnew = this.pointTry(pHigh, 0.5);
            if (pnew.getOutput() > yHighSave) {
                Vector xlow = pLow.getInput();
                for (int i = 0; i < this.simplex.size(); ++i) {
                    DefaultInputOutputPair<Vector, Double> pi = this.simplex.get(i);
                    if (i == indexLow) continue;
                    Vector xi = pi.getInput();
                    xi.plusEquals((Ring)xlow);
                    xi.scaleEquals(0.5);
                    Double yi = (Double)((Evaluator)this.data).evaluate((Object)xi);
                    pi.setInput(xi);
                    pi.setOutput(yi);
                }
                this.simplexInputSum = this.computeSimplexInputSum();
            }
        }
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    protected Vector computeSimplexInputSum() {
        RingAccumulator simplexInputAccumulator = new RingAccumulator();
        for (DefaultInputOutputPair<Vector, Double> pi : this.simplex) {
            simplexInputAccumulator.accumulate((Ring)pi.getInput());
        }
        return (Vector)simplexInputAccumulator.getSum();
    }

    private DefaultInputOutputPair<Vector, Double> pointTry(DefaultInputOutputPair<Vector, Double> pold, double scaleFactor) {
        int M = ((Vector)this.initialGuess).getDimensionality();
        Vector xold = pold.getInput();
        Vector xmid = (Vector)this.simplexInputSum.minus((Ring)xold);
        xmid.scaleEquals(1.0 / (double)M);
        Vector direction = (Vector)xold.minus((Ring)xmid);
        this.lineFunction.setDirection(direction);
        this.lineFunction.setVectorOffset(xmid);
        Vector xnew = this.lineFunction.computeVector(scaleFactor);
        double ynew = this.lineFunction.evaluate(scaleFactor);
        DefaultInputOutputPair<Vector, Double> pnew = new DefaultInputOutputPair<Vector, Double>(xnew, ynew);
        if (ynew < pold.getOutput()) {
            this.simplexInputSum.minusEquals((Ring)pold.getInput());
            this.simplexInputSum.plusEquals((Ring)xnew);
            pold.setInput(xnew);
            pold.setOutput(ynew);
        }
        return pnew;
    }
}

