/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.math.matrix.Vector;

public class MinimizationStoppingCriterion {
    private static final double TOLERANCE_DELTA_X = 1.0E-7;

    public static boolean convergence(Vector xnew, Double fxnew, Vector gradient, Vector delta, double tolerance) {
        double maximumDelta = 0.0;
        double maximumGradient = 0.0;
        double gradDenom = fxnew == null ? 1.0 : Math.max(fxnew, 1.0);
        for (int i = 0; i < xnew.getDimensionality(); ++i) {
            double gradX;
            double normalizedX = Math.max(Math.abs(xnew.getElement(i)), 1.0);
            double deltaX = Math.abs(delta.getElement(i)) / normalizedX;
            if (maximumDelta < deltaX) {
                maximumDelta = deltaX;
            }
            if (!(maximumGradient < (gradX = Math.abs(gradient.getElement(i)) * normalizedX / gradDenom))) continue;
            maximumGradient = gradX;
        }
        return maximumDelta < 1.0E-7 || maximumGradient < tolerance;
    }
}

