/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line.interpolator;

import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.AbstractLineBracketInterpolatorPolynomial;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.scalar.PolynomialFunction;
import gov.sandia.cognition.math.DifferentiableUnivariateScalarFunction;

public class LineBracketInterpolatorHermiteParabola
extends AbstractLineBracketInterpolatorPolynomial<DifferentiableUnivariateScalarFunction> {
    public LineBracketInterpolatorHermiteParabola() {
        super(1.0E-6);
    }

    @Override
    public boolean hasSufficientPoints(LineBracket bracket) {
        return bracket.getLowerBound() != null && bracket.getUpperBound() != null && !Double.isInfinite((Double)bracket.getLowerBound().getOutput()) && !Double.isInfinite((Double)bracket.getUpperBound().getOutput());
    }

    @Override
    public PolynomialFunction.ClosedForm computePolynomial(LineBracket bracket, DifferentiableUnivariateScalarFunction function) {
        InputOutputSlopeTriplet p1;
        InputOutputSlopeTriplet p0;
        InputOutputSlopeTriplet a = bracket.getLowerBound();
        InputOutputSlopeTriplet b = bracket.getUpperBound();
        if (a.getSlope() != null) {
            p0 = a;
            p1 = b;
        } else if (b.getSlope() != null) {
            p0 = b;
            p1 = a;
        } else {
            Double slope = (Double)function.differentiate(a.getInput());
            a.setSlope(slope);
            p0 = a;
            p1 = b;
        }
        return PolynomialFunction.Quadratic.fit(p0, (InputOutputPair<Double, Double>)p1);
    }
}

