/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line.interpolator;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.AbstractLineBracketInterpolatorPolynomial;
import gov.sandia.cognition.learning.function.scalar.PolynomialFunction;

public class LineBracketInterpolatorParabola
extends AbstractLineBracketInterpolatorPolynomial<Evaluator<Double, Double>> {
    public LineBracketInterpolatorParabola() {
        super(1.0E-6);
    }

    @Override
    public boolean hasSufficientPoints(LineBracket bracket) {
        return bracket.getLowerBound() != null && bracket.getUpperBound() != null && bracket.getOtherPoint() != null && !Double.isInfinite((Double)bracket.getLowerBound().getOutput()) && !Double.isInfinite((Double)bracket.getUpperBound().getOutput()) && !Double.isInfinite((Double)bracket.getOtherPoint().getOutput());
    }

    @Override
    public PolynomialFunction.ClosedForm computePolynomial(LineBracket bracket, Evaluator<Double, Double> function) {
        InputOutputSlopeTriplet p0 = bracket.getLowerBound();
        InputOutputSlopeTriplet p1 = bracket.getOtherPoint();
        InputOutputSlopeTriplet p2 = bracket.getUpperBound();
        return PolynomialFunction.Quadratic.fit(p0, p1, p2);
    }
}

