/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.AbstractOnlineLinearBinaryCategorizerLearner;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;

@PublicationReference(author={"Nick Littlestone"}, title="Learning Quickly When Irrelevant Attributes Abound: A New Linear-threshold Algorithm", year=1988, type=PublicationType.Journal, publication="Machine Learning", pages={285, 318})
public class Winnow
extends AbstractOnlineLinearBinaryCategorizerLearner {
    public static final double DEFAULT_WEIGHT_UPDATE = 2.0;
    public static final boolean DEFAULT_DEMOTE_TO_ZERO = false;
    protected double weightUpdate;
    protected boolean demoteToZero;
    protected double weightUpdateInverse;

    public Winnow() {
        this(2.0, false);
    }

    public Winnow(double weightUpdate) {
        this(weightUpdate, false);
    }

    public Winnow(double weightUpdate, boolean demoteToZero) {
        this.setWeightUpdate(weightUpdate);
        this.setDemoteToZero(demoteToZero);
    }

    @Override
    public Winnow clone() {
        return (Winnow)super.clone();
    }

    @Override
    public LinearBinaryCategorizer createInitialLearnedObject() {
        return new LinearBinaryCategorizer();
    }

    @Override
    public void update(LinearBinaryCategorizer target, Vector input, boolean actual) {
        boolean prediction;
        boolean error;
        Vector weights = target.getWeights();
        if (weights == null) {
            int dimensionality = input.getDimensionality();
            weights = this.getVectorFactory().copyVector(input);
            for (int i = 0; i < dimensionality; ++i) {
                weights.setElement(i, 1.0);
            }
            target.setWeights(weights);
            target.setBias((double)(-input.getDimensionality()) / 2.0);
        }
        boolean bl = error = actual != (prediction = ((Boolean)target.evaluate(input)).booleanValue());
        if (error) {
            double update = actual ? this.weightUpdate : (this.demoteToZero ? 0.0 : this.weightUpdateInverse);
            for (VectorEntry entry : input) {
                if (!(entry.getValue() > 0.0)) continue;
                int i = entry.getIndex();
                weights.setElement(i, update * weights.getElement(i));
            }
        }
    }

    public double getWeightUpdate() {
        return this.weightUpdate;
    }

    public void setWeightUpdate(double weightUpdate) {
        if (weightUpdate <= 1.0) {
            throw new IllegalArgumentException("weightUpdate must be greater than 1.0.");
        }
        this.weightUpdate = weightUpdate;
        this.weightUpdateInverse = 1.0 / weightUpdate;
    }

    public boolean isDemoteToZero() {
        return this.demoteToZero;
    }

    public void setDemoteToZero(boolean demoteToZero) {
        this.demoteToZero = demoteToZero;
    }
}

