/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.tree.AbstractDecisionTreeNode;
import gov.sandia.cognition.learning.algorithm.tree.DecisionTreeNode;
import gov.sandia.cognition.learning.function.categorization.Categorizer;

public class RegressionTreeNode<InputType, InteriorType>
extends AbstractDecisionTreeNode<InputType, Double, InteriorType> {
    public static final double DEFAULT_VALUE = 0.0;
    protected Evaluator<? super InputType, Double> scalarFunction;
    protected double value;

    public RegressionTreeNode() {
        this(null, 0.0);
    }

    public RegressionTreeNode(DecisionTreeNode<InputType, Double> parent, double value) {
        this(parent, null, null, value, null);
    }

    public RegressionTreeNode(DecisionTreeNode<InputType, Double> parent, Categorizer<? super InputType, ? extends InteriorType> decider, double value) {
        this(parent, decider, null, value, null);
    }

    public RegressionTreeNode(DecisionTreeNode<InputType, Double> parent, Evaluator<? super InputType, Double> scalarFunction, double value) {
        this(parent, scalarFunction, value, null);
    }

    public RegressionTreeNode(DecisionTreeNode<InputType, Double> parent, Evaluator<? super InputType, Double> scalarFunction, double value, Object incomingValue) {
        this(parent, null, scalarFunction, value, incomingValue);
    }

    public RegressionTreeNode(DecisionTreeNode<InputType, Double> parent, Categorizer<? super InputType, ? extends InteriorType> decider, Evaluator<? super InputType, Double> scalarFunction, double value, Object incomingValue) {
        super(parent, decider, incomingValue);
        this.setScalarFunction(scalarFunction);
        this.setValue(value);
    }

    @Override
    public RegressionTreeNode<InputType, InteriorType> clone() {
        return (RegressionTreeNode)super.clone();
    }

    @Override
    public Double getOutput(InputType input) {
        if (this.scalarFunction == null) {
            return this.value;
        }
        return (Double)this.scalarFunction.evaluate(input);
    }

    public Evaluator<? super InputType, Double> getScalarFunction() {
        return this.scalarFunction;
    }

    public void setScalarFunction(Evaluator<? super InputType, Double> scalarFunction) {
        this.scalarFunction = scalarFunction;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }
}

