/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.learning.algorithm.IncrementalLearner;
import gov.sandia.cognition.learning.experiment.AbstractLearningExperiment;
import gov.sandia.cognition.learning.performance.PerformanceEvaluator;
import gov.sandia.cognition.util.Summarizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class OnlineLearnerValidationExperiment<DataType, LearnedType, StatisticType, SummaryType>
extends AbstractLearningExperiment
implements PerformanceEvaluator<IncrementalLearner<? super DataType, LearnedType>, Collection<? extends DataType>, SummaryType>,
Serializable {
    protected PerformanceEvaluator<? super LearnedType, ? super Collection<? extends DataType>, ? extends StatisticType> performanceEvaluator;
    protected Summarizer<? super StatisticType, ? extends SummaryType> summarizer;
    protected int numTrials;
    protected ArrayList<StatisticType> statistics;
    protected SummaryType summary;

    public OnlineLearnerValidationExperiment() {
        this(null, null);
    }

    public OnlineLearnerValidationExperiment(PerformanceEvaluator<? super LearnedType, ? super Collection<? extends DataType>, ? extends StatisticType> performanceEvaluator, Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        this.setPerformanceEvaluator(performanceEvaluator);
        this.setSummarizer(summarizer);
        this.setNumTrials(-1);
        this.setStatistics(null);
        this.setSummary(null);
    }

    @Override
    public SummaryType evaluatePerformance(IncrementalLearner<? super DataType, LearnedType> learner, Collection<? extends DataType> data) {
        this.setNumTrials(data.size());
        this.setStatistics(new ArrayList(data.size()));
        this.setSummary(null);
        this.fireExperimentStarted();
        LearnedType learned = learner.createInitialLearnedObject();
        for (DataType item : data) {
            this.fireTrialStarted();
            StatisticType statistic = this.getPerformanceEvaluator().evaluatePerformance(learned, Collections.singletonList(item));
            this.statistics.add(statistic);
            learner.update(learned, item);
            this.fireTrialEnded();
        }
        this.setSummary(this.getSummarizer().summarize(this.getStatistics()));
        this.fireExperimentEnded();
        return this.getSummary();
    }

    public PerformanceEvaluator<? super LearnedType, ? super Collection<? extends DataType>, ? extends StatisticType> getPerformanceEvaluator() {
        return this.performanceEvaluator;
    }

    public void setPerformanceEvaluator(PerformanceEvaluator<? super LearnedType, ? super Collection<? extends DataType>, ? extends StatisticType> performanceEvaluator) {
        this.performanceEvaluator = performanceEvaluator;
    }

    public Summarizer<? super StatisticType, ? extends SummaryType> getSummarizer() {
        return this.summarizer;
    }

    public void setSummarizer(Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        this.summarizer = summarizer;
    }

    @Override
    public int getNumTrials() {
        return this.numTrials;
    }

    protected void setNumTrials(int numTrials) {
        this.numTrials = numTrials;
    }

    public ArrayList<StatisticType> getStatistics() {
        return this.statistics;
    }

    protected void setStatistics(ArrayList<StatisticType> statistics) {
        this.statistics = statistics;
    }

    public SummaryType getSummary() {
        return this.summary;
    }

    protected void setSummary(SummaryType summary) {
        this.summary = summary;
    }
}

