/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.function.categorization.ConfidenceWeightedBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.statistics.distribution.BernoulliDistribution;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;

public abstract class AbstractConfidenceWeightedBinaryCategorizer
extends LinearBinaryCategorizer
implements ConfidenceWeightedBinaryCategorizer {
    public AbstractConfidenceWeightedBinaryCategorizer() {
    }

    public AbstractConfidenceWeightedBinaryCategorizer(Vector mean) {
        super(mean, 0.0);
    }

    @Override
    public BernoulliDistribution evaluateAsBernoulli(Vectorizable input) {
        double pZero = this.evaluateAsGaussian(input).getCDF().evaluate(0.0);
        double pOne = 1.0 - pZero;
        return new BernoulliDistribution(pOne);
    }

    @Override
    public boolean isInitialized() {
        return this.getMean() != null && this.getCovariance() != null;
    }

    @Override
    public MultivariateGaussian createWeightDistribution() {
        return new MultivariateGaussian(this.getMean(), this.getCovariance());
    }

    @Override
    public Vector getMean() {
        return this.getWeights();
    }

    public void setMean(Vector mean) {
        this.setWeights(mean);
    }
}

