/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.collection.FiniteCapacityBuffer;
import gov.sandia.cognition.evaluator.AbstractStatefulEvaluator;
import gov.sandia.cognition.statistics.CumulativeDistributionFunction;
import gov.sandia.cognition.statistics.distribution.ChiSquareDistribution;
import gov.sandia.cognition.statistics.method.KolmogorovSmirnovConfidence;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;

public class KolmogorovSmirnovEvaluator
extends AbstractStatefulEvaluator<Double, Double, FiniteCapacityBuffer<Double>> {
    public static final int DEFAULT_CAPACITY = 100;
    public static final CumulativeDistributionFunction<Double> DEFAULT_CDF = new ChiSquareDistribution.CDF(3.0);
    protected CumulativeDistributionFunction<Double> cdf;
    private int capacity;

    public KolmogorovSmirnovEvaluator() {
        this((CumulativeDistributionFunction)ObjectUtil.cloneSafe(DEFAULT_CDF), 100);
    }

    public KolmogorovSmirnovEvaluator(CumulativeDistributionFunction<Double> cdf, int capacity) {
        this.setCDF(cdf);
        this.setCapacity(capacity);
    }

    public KolmogorovSmirnovEvaluator clone() {
        KolmogorovSmirnovEvaluator clone = (KolmogorovSmirnovEvaluator)super.clone();
        clone.setCDF((CumulativeDistributionFunction)ObjectUtil.cloneSafe(this.getCDF()));
        return clone;
    }

    public Double evaluate(Double value) {
        Double result = 0.0;
        if (value != null) {
            ((FiniteCapacityBuffer)this.getState()).addLast((Object)value);
            result = KolmogorovSmirnovConfidence.evaluateNullHypothesis((Collection)this.getState(), this.cdf).getNullHypothesisProbability();
        }
        return result;
    }

    public CumulativeDistributionFunction<Double> getCDF() {
        return this.cdf;
    }

    public void setCDF(CumulativeDistributionFunction<Double> cdf) {
        this.cdf = cdf;
    }

    public FiniteCapacityBuffer<Double> createDefaultState() {
        return new FiniteCapacityBuffer(this.getCapacity());
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

