/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.learning.function.scalar.LinearFunction;
import gov.sandia.cognition.learning.function.vector.ElementWiseVectorFunction;
import gov.sandia.cognition.math.DifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.DifferentiableVectorFunction;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;

public class ElementWiseDifferentiableVectorFunction
extends ElementWiseVectorFunction
implements DifferentiableVectorFunction {
    public ElementWiseDifferentiableVectorFunction() {
        this((DifferentiableUnivariateScalarFunction)new LinearFunction());
    }

    public ElementWiseDifferentiableVectorFunction(DifferentiableUnivariateScalarFunction scalarFunction) {
        super((UnivariateScalarFunction)scalarFunction);
    }

    public Matrix differentiate(Vector input) {
        int M = input.getDimensionality();
        Matrix dydx = MatrixFactory.getDefault().createMatrix(M, M);
        for (int i = 0; i < M; ++i) {
            dydx.setElement(i, i, this.getScalarFunction().differentiate(input.getElement(i)));
        }
        return dydx;
    }

    public DifferentiableUnivariateScalarFunction getScalarFunction() {
        return (DifferentiableUnivariateScalarFunction)super.getScalarFunction();
    }

    @Override
    public void setScalarFunction(UnivariateScalarFunction scalarFunction) {
        super.setScalarFunction((UnivariateScalarFunction)((DifferentiableUnivariateScalarFunction)scalarFunction));
    }
}

