/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance.categorization;

import gov.sandia.cognition.learning.performance.categorization.DefaultBinaryConfusionMatrix;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.StudentTConfidence;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Summarizer;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultBinaryConfusionMatrixConfidenceInterval {
    private double confidence;
    private ConfidenceInterval falseNegativesRate;
    private ConfidenceInterval falsePositivesRate;
    private ConfidenceInterval truePositivesRate;
    private ConfidenceInterval trueNegativesRate;

    public DefaultBinaryConfusionMatrixConfidenceInterval(double confidence, ConfidenceInterval falsePositivesRate, ConfidenceInterval falseNegativesRate, ConfidenceInterval truePositivesRate, ConfidenceInterval trueNegativesRate) {
        this.setConfidence(confidence);
        this.setFalseNegativesRate(falseNegativesRate);
        this.setFalsePositivesRate(falsePositivesRate);
        this.setTruePositivesRate(truePositivesRate);
        this.setTrueNegativesRate(trueNegativesRate);
    }

    public ConfidenceInterval getFalsePositivesRate() {
        return this.falsePositivesRate;
    }

    protected void setFalsePositivesRate(ConfidenceInterval falsePositivesRate) {
        this.falsePositivesRate = falsePositivesRate;
    }

    public ConfidenceInterval getFalseNegativesRate() {
        return this.falseNegativesRate;
    }

    protected void setFalseNegativesRate(ConfidenceInterval falseNegativesRate) {
        this.falseNegativesRate = falseNegativesRate;
    }

    public ConfidenceInterval getTruePositivesRate() {
        return this.truePositivesRate;
    }

    protected void setTruePositivesRate(ConfidenceInterval truePositivesRate) {
        this.truePositivesRate = truePositivesRate;
    }

    public ConfidenceInterval getTrueNegativesRate() {
        return this.trueNegativesRate;
    }

    protected void setTrueNegativesRate(ConfidenceInterval trueNegativesRate) {
        this.trueNegativesRate = trueNegativesRate;
    }

    public double getConfidence() {
        return this.confidence;
    }

    protected void setConfidence(double confidence) {
        DefaultBinaryConfusionMatrixConfidenceInterval.checkConfidence(confidence);
        this.confidence = confidence;
    }

    protected static void checkConfidence(double confidence) {
        if (confidence < 0.0 || confidence > 1.0) {
            throw new IllegalArgumentException("confidence must be between 0.0 and 1.0");
        }
    }

    public String toString() {
        return "True Negatives: " + (Object)((Object)this.getTrueNegativesRate()) + "\n" + "False Positives: " + (Object)((Object)this.getFalsePositivesRate()) + "\n" + "False Negatives: " + (Object)((Object)this.getFalseNegativesRate()) + "\n" + "True Positives: " + (Object)((Object)this.getTruePositivesRate());
    }

    public static DefaultBinaryConfusionMatrixConfidenceInterval compute(Collection<? extends DefaultBinaryConfusionMatrix> data, double confidence) {
        ArrayList<Double> fpp = new ArrayList<Double>(data.size());
        ArrayList<Double> fnp = new ArrayList<Double>(data.size());
        ArrayList<Double> tpp = new ArrayList<Double>(data.size());
        ArrayList<Double> tnp = new ArrayList<Double>(data.size());
        for (DefaultBinaryConfusionMatrix defaultBinaryConfusionMatrix : data) {
            double positives = defaultBinaryConfusionMatrix.getTruePositivesCount() + defaultBinaryConfusionMatrix.getFalseNegativesCount();
            double negatives = defaultBinaryConfusionMatrix.getTrueNegativesCount() + defaultBinaryConfusionMatrix.getFalsePositivesCount();
            if (positives != 0.0) {
                tpp.add(defaultBinaryConfusionMatrix.getTruePositivesRate());
                fnp.add(defaultBinaryConfusionMatrix.getFalseNegativesRate());
            }
            if (negatives == 0.0) continue;
            tnp.add(defaultBinaryConfusionMatrix.getTrueNegativesRate());
            fpp.add(defaultBinaryConfusionMatrix.getFalsePositivesRate());
        }
        StudentTConfidence ttest = new StudentTConfidence();
        ConfidenceInterval confidenceInterval = ttest.computeConfidenceInterval((Collection<? extends Number>)fpp, confidence);
        ConfidenceInterval fnci = ttest.computeConfidenceInterval((Collection<? extends Number>)fnp, confidence);
        ConfidenceInterval tpci = ttest.computeConfidenceInterval((Collection<? extends Number>)tpp, confidence);
        ConfidenceInterval tnci = ttest.computeConfidenceInterval((Collection<? extends Number>)tnp, confidence);
        return new DefaultBinaryConfusionMatrixConfidenceInterval(confidence, confidenceInterval, fnci, tpci, tnci);
    }

    public static class Summary
    extends AbstractCloneableSerializable
    implements Summarizer<DefaultBinaryConfusionMatrix, DefaultBinaryConfusionMatrixConfidenceInterval> {
        private double confidence;

        public Summary(double confidence) {
            this.setConfidence(confidence);
        }

        public DefaultBinaryConfusionMatrixConfidenceInterval summarize(Collection<? extends DefaultBinaryConfusionMatrix> data) {
            return DefaultBinaryConfusionMatrixConfidenceInterval.compute(data, this.confidence);
        }

        public double getConfidence() {
            return this.confidence;
        }

        public void setConfidence(double confidence) {
            DefaultBinaryConfusionMatrixConfidenceInterval.checkConfidence(confidence);
            this.confidence = confidence;
        }
    }
}

