/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.statistics.PointMassDistribution;
import gov.sandia.cognition.statistics.bayesian.AbstractParticleFilter;
import gov.sandia.cognition.util.DefaultWeightedValue;
import java.util.ArrayList;

@PublicationReference(author={"M. Sanjeev Arulampalam", "Simon Maskell", "Neil Gordon", "Tim Clapp"}, title="A Tutorial on Particle Filters for Online Nonlinear/Non-Gaussian Bayesian Tracking", type=PublicationType.Journal, publication="IEEE Transactions on Signal Processing, Vol. 50, No. 2", year=2002, pages={174, 188}, url="http://people.cs.ubc.ca/~murphyk/Software/Kalman/ParticleFilterTutorial.pdf")
public class SamplingImportanceResamplingParticleFilter<ObservationType, ParameterType>
extends AbstractParticleFilter<ObservationType, ParameterType> {
    protected double particlePctThreadhold;

    public double getParticlePctThreadhold() {
        return this.particlePctThreadhold;
    }

    public void setParticlePctThreadhold(double particlePctThreadhold) {
        ProbabilityUtil.assertIsProbability((double)particlePctThreadhold);
        this.particlePctThreadhold = particlePctThreadhold;
    }

    @Override
    public void update(PointMassDistribution<ParameterType> particles, ObservationType value) {
        ArrayList sampledParticles = particles.sample(this.random, this.numParticles);
        ArrayList<DefaultWeightedValue> updatedParticles = new ArrayList<DefaultWeightedValue>(this.numParticles);
        double weightSum = 0.0;
        for (Object sampledParticle : sampledParticles) {
            Object updatedParticle = this.getUpdater().update(sampledParticle);
            double previousWeight = particles.getMass(sampledParticle);
            double weight = previousWeight * Math.exp(this.getUpdater().computeLogLikelihood(updatedParticle, value));
            weightSum += weight;
            updatedParticles.add(new DefaultWeightedValue(updatedParticle, weight));
        }
        particles.clear();
        for (DefaultWeightedValue updatedParticle : updatedParticles) {
            double weight = updatedParticle.getWeight();
            particles.add(updatedParticle.getValue(), weight / weightSum);
        }
        double particlePct = this.computeEffectiveParticles(particles) / (double)this.getNumParticles();
        if (particlePct < this.getParticlePctThreadhold()) {
            sampledParticles = particles.sample(this.random, this.numParticles);
            double uniformWeight = 1.0 / (double)this.numParticles;
            particles.clear();
            for (Object sampledParticle : sampledParticles) {
                Object resampledParticle = this.getUpdater().update(sampledParticle);
                particles.add(resampledParticle, uniformWeight);
            }
        }
    }
}

