/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.conjugate.ConjugatePriorBayesianEstimatorPredictor;
import gov.sandia.cognition.statistics.distribution.DirichletDistribution;
import gov.sandia.cognition.statistics.distribution.MultinomialDistribution;
import gov.sandia.cognition.statistics.distribution.MultivariatePolyaDistribution;

@PublicationReference(author={"Wikipedia"}, title="Conjugate Prior", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Conjugate_prior")
public class MultinomialBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Vector, Vector, MultinomialDistribution, DirichletDistribution>
implements ConjugatePriorBayesianEstimatorPredictor<Vector, Vector, MultinomialDistribution, DirichletDistribution> {
    public static final int DEFAULT_NUM_TRIALS = 2;
    public static final int DEFAULT_NUM_CLASSES = 2;

    public MultinomialBayesianEstimator() {
        this(2);
    }

    public MultinomialBayesianEstimator(int numTrials) {
        this(2, numTrials);
    }

    public MultinomialBayesianEstimator(int numClasses, int numTrials) {
        this(new DirichletDistribution(VectorFactory.getDefault().createVector(numClasses, 1.0)), numTrials);
    }

    public MultinomialBayesianEstimator(DirichletDistribution initialBelief, int numTrials) {
        this(new MultinomialDistribution(initialBelief.getParameters().getDimensionality(), numTrials), initialBelief);
    }

    public MultinomialBayesianEstimator(MultinomialDistribution conditional, DirichletDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    protected MultinomialBayesianEstimator(BayesianParameter<Vector, MultinomialDistribution, DirichletDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(MultinomialDistribution conditional, DirichletDistribution prior) {
        return new Parameter(conditional, prior);
    }

    @Override
    public double computeEquivalentSampleSize(DirichletDistribution belief) {
        Vector a = belief.getParameters();
        return a.norm1() / (double)this.getNumTrials();
    }

    @Override
    public void update(DirichletDistribution belief, Vector value) {
        Vector a = belief.getParameters();
        Vector anext = (Vector)a.plus((Ring)value);
        belief.setParameters(anext);
    }

    public int getNumTrials() {
        return ((MultinomialDistribution)this.parameter.getConditionalDistribution()).getNumTrials();
    }

    public void setNumTrials(int numTrials) {
        if (numTrials <= 0) {
            throw new IllegalArgumentException("numTrials must be > 0");
        }
        ((MultinomialDistribution)this.parameter.getConditionalDistribution()).setNumTrials(numTrials);
    }

    @Override
    public MultinomialDistribution createConditionalDistribution(Vector parameter) {
        parameter.assertSameDimensionality(((MultinomialDistribution)this.parameter.getConditionalDistribution()).getParameters());
        return (MultinomialDistribution)super.createConditionalDistribution(parameter);
    }

    public MultivariatePolyaDistribution createPredictiveDistribution(DirichletDistribution posterior) {
        return new MultivariatePolyaDistribution.PMF(posterior.getParameters(), this.getNumTrials());
    }

    public static class Parameter
    extends AbstractBayesianParameter<Vector, MultinomialDistribution, DirichletDistribution> {
        public static final String NAME = "parameters";

        public Parameter(MultinomialDistribution conditional, DirichletDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Vector value) {
            value.assertSameDimensionality(((MultinomialDistribution)this.conditionalDistribution).getParameters());
            ((MultinomialDistribution)this.conditionalDistribution).setParameters(value);
        }

        public Vector getValue() {
            return ((MultinomialDistribution)this.conditionalDistribution).getParameters();
        }
    }
}

