/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Log-normal distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Log-normal_distribution")
public class LogNormalDistribution
extends AbstractClosedFormSmoothUnivariateDistribution
implements EstimableDistribution<Double, LogNormalDistribution> {
    public static final double DEFAULT_LOG_NORMAL_MEAN = 0.0;
    public static final double DEFAULT_LOG_NORMAL_VARIANCE = 1.0;
    public static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private double logNormalMean;
    private double logNormalVariance;

    public LogNormalDistribution() {
        this(0.0, 1.0);
    }

    public LogNormalDistribution(double logNormalMean, double logNormalVariance) {
        this.setLogNormalMean(logNormalMean);
        this.setLogNormalVariance(logNormalVariance);
    }

    public LogNormalDistribution(LogNormalDistribution other) {
        this(other.getLogNormalMean(), other.getLogNormalVariance());
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getLogNormalMean(), this.getLogNormalVariance()});
    }

    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 2) {
            throw new IllegalArgumentException("Parameters must be dimension 2");
        }
        this.setLogNormalMean(parameters.getElement(0));
        this.setLogNormalVariance(parameters.getElement(1));
    }

    public double getLogNormalMean() {
        return this.logNormalMean;
    }

    public void setLogNormalMean(double logNormalMean) {
        this.logNormalMean = logNormalMean;
    }

    public double getLogNormalVariance() {
        return this.logNormalVariance;
    }

    public void setLogNormalVariance(double logNormalVariance) {
        if (logNormalVariance <= 0.0) {
            throw new IllegalArgumentException("logNormalVariance must be > 0.0");
        }
        this.logNormalVariance = logNormalVariance;
    }

    @Override
    public Double getMean() {
        double exp = this.getLogNormalMean() + 0.5 * this.getLogNormalVariance();
        return Math.exp(exp);
    }

    @Override
    public double getVariance() {
        double exp1 = this.getLogNormalVariance();
        double exp2 = 2.0 * this.getLogNormalMean() + this.getLogNormalVariance();
        return Math.expm1(exp1) * Math.exp(exp2);
    }

    @Override
    public ArrayList<Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        double std = Math.sqrt(this.logNormalVariance);
        for (int n = 0; n < numSamples; ++n) {
            double normal = random.nextGaussian();
            double exponent = this.logNormalMean + std * normal;
            samples.add(Math.exp(exponent));
        }
        return samples;
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public String toString() {
        return "Log-Mean: " + this.logNormalMean + " Log-Variance: " + this.logNormalVariance;
    }

    @Override
    public Double getMinSupport() {
        return 0.0;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public static class WeightedMaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionWeightedEstimator<Double, LogNormalDistribution> {
        @Override
        public PDF learn(Collection<? extends WeightedValue<? extends Double>> data) {
            ArrayList<DefaultWeightedValue> logdata = new ArrayList<DefaultWeightedValue>(data.size());
            for (WeightedValue<? extends Double> weightedValue : data) {
                double weight;
                double logx;
                double x = ((Number)weightedValue.getValue()).doubleValue();
                if (x > 0.0) {
                    logx = Math.log(x);
                    weight = weightedValue.getWeight();
                } else {
                    logx = Double.NEGATIVE_INFINITY;
                    weight = 0.0;
                }
                logdata.add(new DefaultWeightedValue((Object)logx, weight));
            }
            Pair pair = UnivariateStatisticsUtil.computeWeightedMeanAndVariance(logdata);
            return new PDF((Double)pair.getFirst(), (Double)pair.getSecond());
        }
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Double, LogNormalDistribution> {
        @Override
        public PDF learn(Collection<? extends Double> data) {
            ArrayList<Double> logdata = new ArrayList<Double>(data.size());
            for (Double d : data) {
                logdata.add(Math.log(d));
            }
            Pair pair = UnivariateStatisticsUtil.computeMeanAndVariance(logdata);
            return new PDF((Double)pair.getFirst(), (Double)pair.getSecond());
        }
    }

    public static class CDF
    extends LogNormalDistribution
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
        }

        public CDF(double logNormalMean, double logNormalVariance) {
            super(logNormalMean, logNormalVariance);
        }

        public CDF(LogNormalDistribution other) {
            super(other);
        }

        public double evaluate(double input) {
            return CDF.evaluate(input, this.getLogNormalMean(), this.getLogNormalVariance());
        }

        public static double evaluate(double x, double logNormalMean, double logNormalVariance) {
            if (x <= 0.0) {
                return 0.0;
            }
            double num = Math.log(x) - logNormalMean;
            double denom = Math.sqrt(2.0 * logNormalVariance);
            double erf = UnivariateGaussian.ErrorFunction.INSTANCE.evaluate(num / denom);
            return 0.5 * (1.0 + erf);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }

    public static class PDF
    extends LogNormalDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double logNormalMean, double logNormalVariance) {
            super(logNormalMean, logNormalVariance);
        }

        public PDF(LogNormalDistribution other) {
            super(other);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            return PDF.evaluate(input, this.getLogNormalMean(), this.getLogNormalVariance());
        }

        public static double evaluate(double input, double logNormalMean, double logNormalVariance) {
            if (input <= 0.0) {
                return 0.0;
            }
            double delta = Math.log(input) - logNormalMean;
            double exp = Math.exp(delta * delta / (-2.0 * logNormalVariance));
            double denom = SQRT2PI * input * Math.sqrt(logNormalVariance);
            return exp / denom;
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            return PDF.logEvaluate(input, this.getLogNormalMean(), this.getLogNormalVariance());
        }

        public static double logEvaluate(double input, double logNormalMean, double logNormalVariance) {
            double logInput = Math.log(input);
            double delta = logInput - logNormalMean;
            double exponent = delta * delta / (-2.0 * logNormalVariance);
            double coefficient = -0.5 * Math.log(Math.PI * 2 * logNormalVariance);
            return exponent + coefficient - logInput;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

