/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.DistributionWeightedEstimator;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.LinearMixtureModel;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Randomized;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-10-20", changesNeeded=true, comments={"Fixed some missing javadoc.", "General style fixes.", "Added task to figure out a way to avoid storing weights in matrix.", "Generally looks good.", "Some argument checks need to be more complete"}, response={@CodeReviewResponse(date="2009-10-20", respondent="Dan Morrow", comments={"added additional test coverage", "added more argument checks"}, moreChangesNeeded=false)})
@PublicationReference(author={"Wikipedia"}, title="Mixture Model", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Mixture_density")
public class ScalarMixtureDensityModel
extends LinearMixtureModel<Double, SmoothUnivariateDistribution>
implements SmoothUnivariateDistribution {
    public ScalarMixtureDensityModel() {
        this(new UnivariateGaussian());
    }

    public ScalarMixtureDensityModel(SmoothUnivariateDistribution ... distributions) {
        this((Collection<? extends SmoothUnivariateDistribution>)Arrays.asList(distributions));
    }

    public ScalarMixtureDensityModel(Collection<? extends SmoothUnivariateDistribution> distributions) {
        this(distributions, (double[])null);
    }

    public ScalarMixtureDensityModel(Collection<? extends SmoothUnivariateDistribution> distributions, double[] priorWeights) {
        super(distributions, priorWeights);
    }

    public ScalarMixtureDensityModel(ScalarMixtureDensityModel other) {
        this(ObjectUtil.cloneSmartElementsAsArrayList(other.getDistributions()), (double[])ObjectUtil.deepCopy((Serializable)other.getPriorWeights()));
    }

    @Override
    public ScalarMixtureDensityModel clone() {
        ScalarMixtureDensityModel clone = (ScalarMixtureDensityModel)super.clone();
        clone.setDistributions(ObjectUtil.cloneSmartElementsAsArrayList(this.getDistributions()));
        clone.setPriorWeights((double[])ObjectUtil.cloneSmart((Object)this.getPriorWeights()));
        return clone;
    }

    public Vector convertToVector() {
        int dim = this.getDistributionCount();
        ArrayList<Vector> parameters = new ArrayList<Vector>(this.getDistributionCount());
        for (SmoothUnivariateDistribution d : this.distributions) {
            Vector p = d.convertToVector();
            dim += p.getDimensionality();
            parameters.add(p);
        }
        Vector p = VectorFactory.getDefault().createVector(dim);
        int index = 0;
        for (int i = 0; i < this.getDistributionCount(); ++i) {
            p.setElement(index, this.priorWeights[i]);
            ++index;
        }
        for (Vector parameter : parameters) {
            for (int i = 0; i < parameter.getDimensionality(); ++i) {
                p.setElement(index, parameter.getElement(i));
                ++index;
            }
        }
        return p;
    }

    public void convertFromVector(Vector parameters) {
        int dim = this.getDistributionCount();
        ArrayList<Vector> ps = new ArrayList<Vector>(this.getDistributionCount());
        for (SmoothUnivariateDistribution d : this.distributions) {
            Vector p = d.convertToVector();
            dim += p.getDimensionality();
            ps.add(p);
        }
        parameters.assertDimensionalityEquals(dim);
        int index = 0;
        for (int i = 0; i < this.getDistributionCount(); ++i) {
            this.priorWeights[i] = parameters.getElement(index);
            ++index;
        }
        int d = 0;
        for (Vector p : ps) {
            for (int i = 0; i < p.getDimensionality(); ++i) {
                p.setElement(i, parameters.getElement(index));
                ++index;
            }
            ((SmoothUnivariateDistribution)this.distributions.get(d)).convertFromVector(p);
            ++d;
        }
    }

    @Override
    public Double getMinSupport() {
        SmoothUnivariateDistribution d;
        double min;
        double minMin = Double.POSITIVE_INFINITY;
        Iterator i$ = this.getDistributions().iterator();
        while (i$.hasNext() && (!(minMin > (min = ((Double)(d = (SmoothUnivariateDistribution)i$.next()).getMinSupport()).doubleValue())) || (minMin = min) != Double.NEGATIVE_INFINITY)) {
        }
        return minMin;
    }

    @Override
    public Double getMaxSupport() {
        SmoothUnivariateDistribution d;
        double max;
        double maxMax = Double.NEGATIVE_INFINITY;
        Iterator i$ = this.getDistributions().iterator();
        while (i$.hasNext() && (!(maxMax < (max = ((Double)(d = (SmoothUnivariateDistribution)i$.next()).getMaxSupport()).doubleValue())) || (maxMax = max) != Double.POSITIVE_INFINITY)) {
        }
        return maxMax;
    }

    @Override
    public Double getMean() {
        double sum = 0.0;
        int i = 0;
        double priorSum = this.getPriorWeightSum();
        for (SmoothUnivariateDistribution d : this.getDistributions()) {
            double prior = this.getPriorWeights()[i];
            sum += prior * d.getMean();
            ++i;
        }
        return sum / priorSum;
    }

    @Override
    @PublicationReference(author={"Wikipedia"}, title="Mixture Model", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Mixture_density")
    public double getVariance() {
        double mean = this.getMean();
        double mean2 = mean * mean;
        double priorWeightSum = 0.0;
        for (int k = 0; k < this.priorWeights.length; ++k) {
            priorWeightSum += this.priorWeights[k];
        }
        if (priorWeightSum <= 0.0) {
            priorWeightSum = 1.0;
        }
        double result = 0.0;
        int i = 0;
        for (SmoothUnivariateDistribution distribution : this.getDistributions()) {
            double mi = distribution.getMean();
            double prior = this.priorWeights[i] / priorWeightSum;
            result += prior * (mi * mi + distribution.getVariance()) - mean2;
            ++i;
        }
        return result;
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    public static class EMLearner
    extends AbstractAnytimeBatchLearner<Collection<? extends Double>, ScalarMixtureDensityModel>
    implements Randomized,
    DistributionEstimator<Double, ScalarMixtureDensityModel>,
    MeasurablePerformanceAlgorithm {
        public static final String PERFORMANCE_NAME = "Assignment Change";
        public static final int DEFAULT_MAX_ITERATIONS = 100;
        public static final double DEFAULT_TOLERANCE = 1.0E-5;
        private Collection<? extends DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution>> learners;
        protected Random random;
        private double tolerance;
        private transient ArrayList<DefaultWeightedValue<Double>> weightedData;
        private transient ArrayList<double[]> assignments;
        private transient ArrayList<UnivariateProbabilityDensityFunction> distributions;
        private transient double[] distributionPrior;
        private transient double assignmentChanged;

        public EMLearner(Random random) {
            this(2, (DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution>)new UnivariateGaussian.WeightedMaximumLikelihoodEstimator(1.0), random);
        }

        public EMLearner(int numClusters, DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution> learner, Random random) {
            super(100);
            this.setTolerance(1.0E-5);
            this.setRandom(random);
            ArrayList<DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution>> ll = new ArrayList<DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution>>(numClusters);
            for (int k = 0; k < numClusters; ++k) {
                ll.add(learner);
            }
            this.setLearners(ll);
        }

        public EMLearner(Random random, DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution> ... learners) {
            super(100);
            this.setTolerance(1.0E-5);
            this.setRandom(random);
            this.setLearners(Arrays.asList(learners));
        }

        @Override
        protected boolean initializeAlgorithm() {
            int N = ((Collection)this.data).size();
            int K = this.learners.size();
            double[] x = new double[K];
            for (int k = 0; k < K; ++k) {
                int index = this.random.nextInt(N);
                x[k] = (Double)CollectionUtil.getElement((Iterable)((Iterable)this.data), (int)index) + this.random.nextGaussian();
            }
            this.weightedData = new ArrayList(N);
            this.assignments = new ArrayList(N);
            this.distributionPrior = new double[K];
            this.assignmentChanged = N;
            for (Double value : (Collection)this.data) {
                int k;
                this.weightedData.add((DefaultWeightedValue<Double>)new DefaultWeightedValue((Object)value, 0.0));
                double[] dArray = new double[K];
                double sum = 0.0;
                for (k = 0; k < K; ++k) {
                    double ak;
                    double delta = value - x[k];
                    dArray[k] = ak = Math.exp(-Math.abs(delta));
                    sum += ak;
                }
                if (sum <= 0.0) {
                    sum = 1.0;
                }
                for (k = 0; k < K; ++k) {
                    int n = k;
                    dArray[n] = dArray[n] / sum;
                    int n2 = k;
                    this.distributionPrior[n2] = this.distributionPrior[n2] + dArray[k];
                }
                this.assignments.add(dArray);
            }
            this.distributions = new ArrayList(K);
            int k = 0;
            for (DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution> distributionWeightedEstimator : this.learners) {
                for (int n = 0; n < N; ++n) {
                    this.weightedData.get(n).setWeight(this.assignments.get(n)[k]);
                }
                this.distributions.add(((SmoothUnivariateDistribution)distributionWeightedEstimator.learn(this.weightedData)).getProbabilityFunction());
                ++k;
            }
            return true;
        }

        @Override
        protected boolean step() {
            int N = ((Collection)this.data).size();
            int K = this.learners.size();
            this.assignmentChanged = 0.0;
            Arrays.fill(this.distributionPrior, 0.0);
            double[] anold = new double[K];
            for (int n = 0; n < N; ++n) {
                double xn = (Double)this.weightedData.get(n).getValue();
                double[] an = this.assignments.get(n);
                System.arraycopy(an, 0, anold, 0, K);
                int k = 0;
                double sum = 0.0;
                for (UnivariateProbabilityDensityFunction pdf : this.distributions) {
                    double ank;
                    an[k] = ank = pdf.evaluate(xn);
                    sum += ank;
                    ++k;
                }
                if (sum <= 0.0) {
                    sum = 1.0;
                }
                k = 0;
                while (k < K) {
                    double ank;
                    an[k] = ank = an[k] / sum;
                    double delta = Math.abs(ank - anold[k]);
                    int n2 = k++;
                    this.distributionPrior[n2] = this.distributionPrior[n2] + ank;
                    this.assignmentChanged += delta;
                }
            }
            if (this.assignmentChanged <= this.getTolerance()) {
                return false;
            }
            int k = 0;
            for (DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution> distributionWeightedEstimator : this.learners) {
                for (int n = 0; n < N; ++n) {
                    this.weightedData.get(n).setWeight(this.assignments.get(n)[k]);
                }
                SmoothUnivariateDistribution distribution = (SmoothUnivariateDistribution)distributionWeightedEstimator.learn(this.weightedData);
                this.distributions.set(k, distribution.getProbabilityFunction());
                ++k;
            }
            return true;
        }

        @Override
        protected void cleanupAlgorithm() {
            this.weightedData = null;
            this.assignments = null;
            this.data = null;
        }

        public ScalarMixtureDensityModel getResult() {
            return new ScalarMixtureDensityModel((Collection<? extends SmoothUnivariateDistribution>)this.distributions, this.distributionPrior);
        }

        public NamedValue<Double> getPerformance() {
            return new DefaultNamedValue(PERFORMANCE_NAME, (Object)this.assignmentChanged);
        }

        public Random getRandom() {
            return this.random;
        }

        public void setRandom(Random random) {
            this.random = random;
        }

        public Collection<? extends DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution>> getLearners() {
            return this.learners;
        }

        public void setLearners(Collection<? extends DistributionWeightedEstimator<Double, ? extends SmoothUnivariateDistribution>> learners) {
            this.learners = learners;
        }

        public double getTolerance() {
            return this.tolerance;
        }

        public void setTolerance(double tolerance) {
            ArgumentChecker.assertIsNonNegative((String)"tolerance", (double)tolerance);
            this.tolerance = tolerance;
        }
    }

    public static class CDF
    extends ScalarMixtureDensityModel
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
        }

        public CDF(SmoothUnivariateDistribution ... distributions) {
            super(distributions);
        }

        public CDF(Collection<? extends SmoothUnivariateDistribution> distributions) {
            super(distributions);
        }

        public CDF(Collection<? extends SmoothUnivariateDistribution> distributions, double[] priorWeights) {
            super(distributions, priorWeights);
        }

        public CDF(ScalarMixtureDensityModel other) {
            super(other);
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            double weightSum = this.getPriorWeightSum();
            double sum = 0.0;
            int i = 0;
            for (SmoothUnivariateDistribution d : this.distributions) {
                SmoothCumulativeDistributionFunction cdf = d.getCDF();
                double prior = this.priorWeights[i];
                sum += prior * cdf.evaluate(input);
                ++i;
            }
            return sum / weightSum;
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate((double)input);
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PDF
    extends ScalarMixtureDensityModel
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(SmoothUnivariateDistribution ... distributions) {
            super(distributions);
        }

        public PDF(Collection<? extends SmoothUnivariateDistribution> distributions) {
            super(distributions);
        }

        public PDF(Collection<? extends SmoothUnivariateDistribution> distributions, double[] priorWeights) {
            super(distributions, priorWeights);
        }

        public PDF(ScalarMixtureDensityModel other) {
            super(other);
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            double weightSum = this.getPriorWeightSum();
            double sum = 0.0;
            int i = 0;
            for (SmoothUnivariateDistribution d : this.distributions) {
                UnivariateProbabilityDensityFunction pdf = d.getProbabilityFunction();
                double prior = this.priorWeights[i];
                sum += prior * pdf.evaluate(input);
                ++i;
            }
            return sum / weightSum;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }

        @Override
        public double logEvaluate(double input) {
            return Math.log(this.evaluate(input));
        }
    }
}

