/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.algorithm.AnytimeAlgorithmWrapper;
import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerBFGS;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.cost.CostFunction;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.matrix.NumericalDifferentiator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.ClosedFormDistribution;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;

public class DistributionParameterEstimator<DataType, DistributionType extends ClosedFormDistribution<? extends DataType>>
extends AnytimeAlgorithmWrapper<DistributionType, FunctionMinimizer<Vector, Double, ? super DistributionWrapper>>
implements BatchLearner<Collection<? extends DataType>, DistributionType>,
MeasurablePerformanceAlgorithm {
    private DistributionWrapper distributionWrapper;
    private DistributionType result;

    public DistributionParameterEstimator(DistributionType distribution, CostFunction<? super DistributionType, Collection<? extends DataType>> costFunction) {
        this((DistributionType)distribution, costFunction, (FunctionMinimizer<Vector, Double, DistributionWrapper>)((FunctionMinimizer<Vector, Double, ? super DistributionWrapper>)new FunctionMinimizerBFGS()));
    }

    public DistributionParameterEstimator(DistributionType distribution, CostFunction<? super DistributionType, Collection<? extends DataType>> costFunction, FunctionMinimizer<Vector, Double, ? super DistributionWrapper> algorithm) {
        super(algorithm);
        this.distributionWrapper = new DistributionWrapper(this, distribution, costFunction);
    }

    public DistributionParameterEstimator<DataType, DistributionType> clone() {
        DistributionParameterEstimator clone = (DistributionParameterEstimator)super.clone();
        clone.distributionWrapper = (DistributionWrapper)ObjectUtil.cloneSafe((CloneableSerializable)this.distributionWrapper);
        clone.result = (ClosedFormDistribution)ObjectUtil.cloneSafe((CloneableSerializable)this.getResult());
        return clone;
    }

    @Override
    public DistributionType learn(Collection<? extends DataType> minimizationParameters) {
        DistributionWrapper wrapperClone = this.distributionWrapper.clone();
        wrapperClone.costFunction.setCostParameters(minimizationParameters);
        ((FunctionMinimizer)this.getAlgorithm()).setInitialGuess(wrapperClone.distribution.convertToVector());
        ((FunctionMinimizer)this.getAlgorithm()).learn(wrapperClone);
        this.result = wrapperClone.distribution;
        return (DistributionType)this.getResult();
    }

    public DistributionType getResult() {
        return this.result;
    }

    public NamedValue<? extends Number> getPerformance() {
        double cost = ((FunctionMinimizer)this.getAlgorithm()).getResult() == null ? 0.0 : (Double)((InputOutputPair)((FunctionMinimizer)this.getAlgorithm()).getResult()).getOutput();
        return new DefaultNamedValue("Cost", (Object)cost);
    }

    protected static class DistributionWrapper
    extends AbstractCloneableSerializable
    implements Evaluator<Vector, Double>,
    DifferentiableEvaluator<Vector, Double, Vector> {
        protected DistributionType distribution;
        protected CostFunction<? super DistributionType, ? super Collection<? extends DataType>> costFunction;
        final /* synthetic */ DistributionParameterEstimator this$0;

        public DistributionWrapper(DistributionType distribution, CostFunction<? super DistributionType, ? super Collection<? extends DataType>> costFunction) {
            this.this$0 = var1_1;
            this.distribution = distribution;
            this.costFunction = costFunction;
        }

        public DistributionWrapper clone() {
            DistributionWrapper clone = (DistributionWrapper)super.clone();
            clone.distribution = (ClosedFormDistribution)ObjectUtil.cloneSafe(this.distribution);
            clone.costFunction = (CostFunction)ObjectUtil.cloneSafe(this.costFunction);
            return clone;
        }

        public Double evaluate(Vector input) {
            try {
                this.distribution.convertFromVector(input);
                return this.costFunction.evaluate(this.distribution);
            }
            catch (Exception e) {
                return Double.POSITIVE_INFINITY;
            }
        }

        public Vector differentiate(Vector input) {
            return NumericalDifferentiator.VectorJacobian.differentiate((Vector)input, (Evaluator)this);
        }
    }
}

