/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.NumberComparator;
import gov.sandia.cognition.statistics.CumulativeDistributionFunction;
import gov.sandia.cognition.statistics.distribution.KolmogorovDistribution;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

@ConfidenceTestAssumptions(name="Kolmogorov-Smirnov test", alsoKnownAs={"K-S test"}, description={"Determines if two datasets were drawn from the same univariate distribution.", "Robust, nonparameteric test that makes no assumptions on the underlying distribution (continuous, discrete, etc.)."}, assumptions={"The data were sampled independently from each other."}, nullHypothesis="The data were drawn from the same distribution.", dataPaired=false, dataSameSize=false, distribution=KolmogorovDistribution.CDF.class, reference={@PublicationReference(author={"Wikipedia"}, title="Kolmogorov-Smirnov test", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Kolmogorov-Smirnov_test")})
public class KolmogorovSmirnovConfidence
extends AbstractCloneableSerializable
implements NullHypothesisEvaluator<Collection<? extends Number>> {
    public static final KolmogorovSmirnovConfidence INSTANCE = new KolmogorovSmirnovConfidence();

    protected static double[] computeAscendingArray(Collection<? extends Number> data) {
        double[] values = new double[data.size()];
        int index = 0;
        for (Number number : data) {
            values[index] = number.doubleValue();
            ++index;
        }
        Arrays.sort(values);
        return values;
    }

    @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={625, 626}, notes={"Section 14.3", "Function kstwo()"}, url="http://www.nrbook.com/a/bookcpdf.php")
    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        double[] dataArray1 = KolmogorovSmirnovConfidence.computeAscendingArray(data1);
        double[] dataArray2 = KolmogorovSmirnovConfidence.computeAscendingArray(data2);
        int j1 = 0;
        int j2 = 0;
        double N1 = dataArray1.length;
        double N2 = dataArray2.length;
        double fn1 = 0.0;
        double fn2 = 0.0;
        double D = 0.0;
        while ((double)j1 < N1 && (double)j2 < N2) {
            double dt;
            double d1 = dataArray1[j1];
            double d2 = dataArray2[j2];
            if (d1 <= d2 || Double.isNaN(d1)) {
                fn1 = (double)(++j1) / N1;
            }
            if (d2 <= d1 || Double.isNaN(d2)) {
                fn2 = (double)(++j2) / N2;
            }
            if (!((dt = Math.abs(fn2 - fn1)) > D)) continue;
            D = dt;
        }
        double Ne = Math.sqrt(N1 * N2 / (N1 + N2));
        return new Statistic(Ne, D);
    }

    @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={625}, notes={"Section 14.3", "Function ksone()"})
    public static <DomainType extends Number> Statistic evaluateNullHypothesis(Collection<? extends DomainType> data1, CumulativeDistributionFunction<DomainType> function) {
        ArrayList<DomainType> sortedData1 = new ArrayList<DomainType>(data1);
        Collections.sort(sortedData1, NumberComparator.INSTANCE);
        for (int n = 1; n < sortedData1.size(); ++n) {
            if (!((Number)sortedData1.get(n - 1)).equals(sortedData1.get(n))) continue;
            sortedData1.set(n - 1, null);
        }
        double fo = 0.0;
        double D = 0.0;
        double Ne = sortedData1.size();
        int j = 0;
        while ((double)j < Ne) {
            double ff;
            double dt;
            double fn = (double)(j + 1) / Ne;
            if (sortedData1.get(j) != null && (dt = Math.max(Math.abs(fo - (ff = ((Double)function.evaluate(sortedData1.get(j))).doubleValue())), Math.abs(fn - ff))) > D) {
                D = dt;
            }
            fo = fn;
            ++j;
        }
        return new Statistic(Ne, D);
    }

    public static Statistic evaluateGaussianHypothesis(Collection<Double> data) {
        UnivariateGaussian.PDF gaussian = UnivariateGaussian.MaximumLikelihoodEstimator.learn(data, 0.0);
        UnivariateGaussian.CDF cdf = new UnivariateGaussian.CDF(gaussian);
        return KolmogorovSmirnovConfidence.evaluateNullHypothesis(data, cdf);
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private double D;
        private double Ne;

        public Statistic(double Ne, double D) {
            super(Statistic.KSsignificance(Ne, D));
            this.setNe(Ne);
            this.setD(D);
        }

        @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={624}, notes={"Section 14.3", "Equation 14.3.9"})
        public static double KSsignificance(double Ne, double D) {
            double Nesqrt = Math.sqrt(Ne);
            double x = (Nesqrt + 0.12 + 0.11 / Nesqrt) * D;
            return 1.0 - KolmogorovDistribution.CDF.evaluate(x);
        }

        public double getD() {
            return this.D;
        }

        protected void setD(double D) {
            if (D < 0.0 || D > 1.0) {
                throw new IllegalArgumentException("0.0 <= D <= 1.0");
            }
            this.D = D;
        }

        public double getNe() {
            return this.Ne;
        }

        protected void setNe(double Ne) {
            if (Ne <= 0.0) {
                throw new IllegalArgumentException("Ne > 0.0");
            }
            this.Ne = Ne;
        }

        @Override
        public double getTestStatistic() {
            return this.getD();
        }
    }
}

