/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.ScalarThresholdBinaryCategorizer;
import gov.sandia.cognition.learning.performance.categorization.DefaultBinaryConfusionMatrix;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.statistics.method.MannWhitneyUConfidence;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

@PublicationReference(author={"Wikipedia"}, title="Receiver operating characteristic", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Receiver_operating_characteristic")
public class ReceiverOperatingCharacteristic
extends AbstractCloneableSerializable
implements Evaluator<Double, Double> {
    private ArrayList<DataPoint> sortedROCData;
    private MannWhitneyUConfidence.Statistic Utest;

    private ReceiverOperatingCharacteristic(Collection<DataPoint> rocData, MannWhitneyUConfidence.Statistic Utest) {
        ArrayList<DataPoint> sortedData = new ArrayList<DataPoint>(rocData);
        Collections.sort(sortedData, new DataPoint.Sorter());
        this.setSortedROCData(sortedData);
        this.setUtest(Utest);
    }

    public ReceiverOperatingCharacteristic clone() {
        ReceiverOperatingCharacteristic clone = (ReceiverOperatingCharacteristic)super.clone();
        clone.setSortedROCData(ObjectUtil.cloneSmartElementsAsArrayList(this.getSortedROCData()));
        clone.setUtest((MannWhitneyUConfidence.Statistic)ObjectUtil.cloneSmart((Object)this.getUtest()));
        return clone;
    }

    public Double evaluate(Double input) {
        double falsePositiveRate = input;
        double truePositiveRate = 0.0;
        for (DataPoint rocData : this.getSortedROCData()) {
            if (!(rocData.getFalsePositiveRate() <= falsePositiveRate)) break;
            truePositiveRate = rocData.getTruePositiveRate();
        }
        return truePositiveRate;
    }

    public ArrayList<DataPoint> getSortedROCData() {
        return this.sortedROCData;
    }

    protected void setSortedROCData(ArrayList<DataPoint> sortedROCData) {
        this.sortedROCData = sortedROCData;
    }

    public static ReceiverOperatingCharacteristic createFromTargetEstimatePairs(Collection<? extends Pair<Boolean, ? extends Number>> data) {
        ArrayList<DefaultInputOutputPair<Double, Object>> transformed = new ArrayList<DefaultInputOutputPair<Double, Object>>(data.size());
        for (Pair<Boolean, ? extends Number> pair : data) {
            transformed.add(DefaultInputOutputPair.create(((Number)pair.getSecond()).doubleValue(), pair.getFirst()));
        }
        return ReceiverOperatingCharacteristic.create(transformed);
    }

    public static ReceiverOperatingCharacteristic create(Collection<? extends InputOutputPair<Double, Boolean>> data) {
        ArrayList<? extends InputOutputPair<Double, Boolean>> sortedData = new ArrayList<InputOutputPair<Double, Boolean>>(data);
        Collections.sort(sortedData, new ROCScoreSorter());
        int totalPositives = 0;
        for (InputOutputPair<Double, Boolean> inputOutputPair : sortedData) {
            if (!inputOutputPair.getOutput().booleanValue()) continue;
            ++totalPositives;
        }
        int total = sortedData.size();
        int n = total - totalPositives;
        int countSoFar = 0;
        int positivesSoFar = 0;
        LinkedList<DataPoint> rocData = new LinkedList<DataPoint>();
        double lastThreshold = Double.NEGATIVE_INFINITY;
        for (InputOutputPair<Double, Boolean> inputOutputPair : sortedData) {
            double trueNegatives = countSoFar - positivesSoFar;
            double falseNegatives = positivesSoFar;
            double truePositives = (double)totalPositives - falseNegatives;
            double falsePositives = (double)n - trueNegatives;
            double threshold = inputOutputPair.getInput();
            if (threshold > lastThreshold) {
                DefaultBinaryConfusionMatrix confusion = new DefaultBinaryConfusionMatrix();
                confusion.setFalsePositivesCount(falsePositives);
                confusion.setFalseNegativesCount(falseNegatives);
                confusion.setTruePositivesCount(truePositives);
                confusion.setTrueNegativesCount(trueNegatives);
                rocData.add(new DataPoint(new ScalarThresholdBinaryCategorizer(threshold), confusion));
                lastThreshold = threshold;
            }
            ++countSoFar;
            boolean target = inputOutputPair.getOutput();
            if (!target) continue;
            ++positivesSoFar;
        }
        MannWhitneyUConfidence.Statistic uTest = new MannWhitneyUConfidence().evaluateNullHypothesis(data);
        return new ReceiverOperatingCharacteristic(rocData, uTest);
    }

    public Statistic computeStatistics() {
        return new Statistic(this);
    }

    public MannWhitneyUConfidence.Statistic getUtest() {
        return this.Utest;
    }

    public void setUtest(MannWhitneyUConfidence.Statistic Utest) {
        this.Utest = Utest;
    }

    private static class ROCScoreSorter
    extends AbstractCloneableSerializable
    implements Comparator<InputOutputPair<Double, ? extends Object>> {
        private ROCScoreSorter() {
        }

        @Override
        public int compare(InputOutputPair<Double, ? extends Object> o1, InputOutputPair<Double, ? extends Object> o2) {
            if (o1.getInput() < o2.getInput()) {
                return -1;
            }
            if (o1.getInput() > o2.getInput()) {
                return 1;
            }
            return 0;
        }
    }

    public static class DataPoint
    extends AbstractCloneableSerializable {
        private ScalarThresholdBinaryCategorizer classifier;
        private DefaultBinaryConfusionMatrix confusionMatrix;

        public DataPoint(ScalarThresholdBinaryCategorizer classifier, DefaultBinaryConfusionMatrix confusionMatrix) {
            this.setClassifier(classifier);
            this.setConfusionMatrix(confusionMatrix);
        }

        public ScalarThresholdBinaryCategorizer getClassifier() {
            return this.classifier;
        }

        public void setClassifier(ScalarThresholdBinaryCategorizer classifier) {
            this.classifier = classifier;
        }

        public DefaultBinaryConfusionMatrix getConfusionMatrix() {
            return this.confusionMatrix;
        }

        protected void setConfusionMatrix(DefaultBinaryConfusionMatrix confusionMatrix) {
            this.confusionMatrix = confusionMatrix;
        }

        public double getFalsePositiveRate() {
            return this.getConfusionMatrix().getFalsePositivesRate();
        }

        public double getTruePositiveRate() {
            return this.getConfusionMatrix().getTruePositivesRate();
        }

        public static class Sorter
        extends AbstractCloneableSerializable
        implements Comparator<DataPoint> {
            @Override
            public int compare(DataPoint o1, DataPoint o2) {
                double y2;
                double x2;
                double x1 = o1.getFalsePositiveRate();
                if (x1 < (x2 = o2.getFalsePositiveRate())) {
                    return -1;
                }
                if (x1 > x2) {
                    return 1;
                }
                double y1 = o1.getTruePositiveRate();
                if (y1 < (y2 = o2.getTruePositiveRate())) {
                    return -1;
                }
                if (y1 > y2) {
                    return 1;
                }
                return 0;
            }
        }
    }

    public static class Statistic
    extends MannWhitneyUConfidence.Statistic {
        private double dPrime;
        private double areaUnderCurve;
        private DataPoint optimalThreshold;

        protected Statistic(ReceiverOperatingCharacteristic roc) {
            super(roc.getUtest());
            this.setAreaUnderCurve(Statistic.computeAreaUnderCurve(roc));
            this.setOptimalThreshold(Statistic.computeOptimalThreshold(roc));
            this.setDPrime(Statistic.computeDPrime(this.getOptimalThreshold()));
        }

        public static double computeAreaUnderCurve(ReceiverOperatingCharacteristic roc) {
            double auc = 0.0;
            int N = roc.getSortedROCData().size();
            for (int n = 1; n <= N; ++n) {
                double xn = n < N ? roc.getSortedROCData().get(n).getFalsePositiveRate() : 1.0;
                double xnm1 = roc.getSortedROCData().get(n - 1).getFalsePositiveRate();
                double ynm1 = roc.getSortedROCData().get(n - 1).getTruePositiveRate();
                double area = ynm1 * (xn - xnm1);
                auc += area;
            }
            return auc;
        }

        public static DataPoint computeOptimalThreshold(ReceiverOperatingCharacteristic roc) {
            return Statistic.computeOptimalThreshold(roc, 1.0, 1.0);
        }

        public static DataPoint computeOptimalThreshold(ReceiverOperatingCharacteristic roc, double truePositiveWeight, double trueNegativeWeight) {
            DataPoint bestData = null;
            double bestValue = Double.NEGATIVE_INFINITY;
            for (DataPoint data : roc.getSortedROCData()) {
                DefaultBinaryConfusionMatrix cm = data.getConfusionMatrix();
                double y = truePositiveWeight * cm.getTruePositivesRate();
                double x = trueNegativeWeight * cm.getTrueNegativesRate();
                double value = x + y;
                if (!(bestValue < value)) continue;
                bestValue = value;
                bestData = data;
            }
            return bestData;
        }

        public static double computeDPrime(DataPoint data) {
            double hitRate = data.getConfusionMatrix().getTruePositivesRate();
            double faRate = data.getFalsePositiveRate();
            double zhr = UnivariateGaussian.CDF.Inverse.evaluate(hitRate, 0.0, 1.0);
            double zfa = UnivariateGaussian.CDF.Inverse.evaluate(faRate, 0.0, 1.0);
            return zhr - zfa;
        }

        public double getDPrime() {
            return this.dPrime;
        }

        protected void setDPrime(double dPrime) {
            this.dPrime = dPrime;
        }

        public double getAreaUnderCurve() {
            return this.areaUnderCurve;
        }

        protected void setAreaUnderCurve(double areaUnderCurve) {
            this.areaUnderCurve = areaUnderCurve;
        }

        public DataPoint getOptimalThreshold() {
            return this.optimalThreshold;
        }

        protected void setOptimalThreshold(DataPoint optimalThreshold) {
            this.optimalThreshold = optimalThreshold;
        }
    }
}

