/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.montecarlo;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.statistics.montecarlo.MonteCarloIntegrator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnivariateMonteCarloIntegrator
extends AbstractCloneableSerializable
implements MonteCarloIntegrator<Double> {
    public static final double DEFAULT_VARIANCE = 0.0;
    public static final UnivariateMonteCarloIntegrator INSTANCE = new UnivariateMonteCarloIntegrator();

    public <SampleType> UnivariateGaussian.PDF integrate(Collection<? extends SampleType> samples, Evaluator<? super SampleType, ? extends Double> expectationFunction) {
        ArrayList<Double> outputs = new ArrayList<Double>(samples.size());
        for (SampleType sample : samples) {
            outputs.add((Double)expectationFunction.evaluate(sample));
        }
        return this.getMean((Collection)outputs);
    }

    public <SampleType> UnivariateGaussian.PDF integrate(List<? extends WeightedValue<? extends SampleType>> samples, Evaluator<? super SampleType, ? extends Double> expectationFunction) {
        ArrayList<DefaultWeightedValue> outputs = new ArrayList<DefaultWeightedValue>(samples.size());
        for (WeightedValue<SampleType> weightedValue : samples) {
            Double output = (Double)expectationFunction.evaluate(weightedValue.getValue());
            outputs.add(new DefaultWeightedValue((Object)output, weightedValue.getWeight()));
        }
        return this.getMean(outputs);
    }

    public UnivariateGaussian.PDF getMean(Collection<? extends Double> samples) {
        UnivariateGaussian.PDF pdf = UnivariateGaussian.MaximumLikelihoodEstimator.learn(samples, 0.0);
        pdf.setVariance(pdf.getVariance() / (double)samples.size());
        return pdf;
    }

    public UnivariateGaussian.PDF getMean(List<? extends WeightedValue<? extends Double>> samples) {
        UnivariateGaussian.PDF pdf = UnivariateGaussian.WeightedMaximumLikelihoodEstimator.learn(samples, 0.0);
        double weightSum = 0.0;
        double sumSquared = 0.0;
        for (WeightedValue<? extends Double> weightedValue : samples) {
            double w = weightedValue.getWeight();
            weightSum += w;
            sumSquared += w * w;
        }
        double ws2 = weightSum * weightSum;
        pdf.setVariance(pdf.getVariance() * sumSquared / ws2);
        return pdf;
    }
}

