/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.context.limit;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.parser.context.limit.LimitValue;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.util.NumberUtil;
import java.util.List;

public final class Limit {
    private LimitValue offset;
    private LimitValue rowCount;

    public int getOffsetValue() {
        return null != this.offset ? this.offset.getValue() : 0;
    }

    public int getRowCountValue() {
        return null != this.rowCount ? this.rowCount.getValue() : -1;
    }

    public void processParameters(List<Object> parameters, boolean isFetchAll, DatabaseType databaseType) {
        this.fill(parameters);
        this.rewrite(parameters, isFetchAll, databaseType);
    }

    private void fill(List<Object> parameters) {
        int offset = 0;
        if (null != this.offset) {
            offset = -1 == this.offset.getIndex() ? this.getOffsetValue() : NumberUtil.roundHalfUp(parameters.get(this.offset.getIndex()));
            this.offset.setValue(offset);
        }
        int rowCount = 0;
        if (null != this.rowCount) {
            rowCount = -1 == this.rowCount.getIndex() ? this.getRowCountValue() : NumberUtil.roundHalfUp(parameters.get(this.rowCount.getIndex()));
            this.rowCount.setValue(rowCount);
        }
        if (offset < 0 || rowCount < 0) {
            throw new SQLParsingException("LIMIT offset and row count can not be a negative value.", new Object[0]);
        }
    }

    private void rewrite(List<Object> parameters, boolean isFetchAll, DatabaseType databaseType) {
        int rewriteOffset = 0;
        int rewriteRowCount = isFetchAll ? Integer.MAX_VALUE : (this.isNeedRewriteRowCount(databaseType) ? (null == this.rowCount ? -1 : this.getOffsetValue() + this.rowCount.getValue()) : this.rowCount.getValue());
        if (null != this.offset && this.offset.getIndex() > -1) {
            parameters.set(this.offset.getIndex(), rewriteOffset);
        }
        if (null != this.rowCount && this.rowCount.getIndex() > -1) {
            parameters.set(this.rowCount.getIndex(), rewriteRowCount);
        }
    }

    public boolean isNeedRewriteRowCount(DatabaseType databaseType) {
        return DatabaseType.MySQL == databaseType || DatabaseType.PostgreSQL == databaseType || DatabaseType.H2 == databaseType;
    }

    public LimitValue getOffset() {
        return this.offset;
    }

    public LimitValue getRowCount() {
        return this.rowCount;
    }

    public void setOffset(LimitValue offset) {
        this.offset = offset;
    }

    public void setRowCount(LimitValue rowCount) {
        this.rowCount = rowCount;
    }

    public String toString() {
        return "Limit(offset=" + this.getOffset() + ", rowCount=" + this.getRowCount() + ")";
    }
}

