/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rule;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import io.shardingsphere.core.exception.ShardingConfigurationException;
import java.beans.ConstructorProperties;
import java.util.List;

public final class DataNode {
    private static final String DELIMITER = ".";
    private final String dataSourceName;
    private final String tableName;

    public DataNode(String dataNode) {
        if (!DataNode.isValidDataNode(dataNode)) {
            throw new ShardingConfigurationException("Invalid format for actual data nodes: '%s'", dataNode);
        }
        List segments = Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNode);
        this.dataSourceName = (String)segments.get(0);
        this.tableName = (String)segments.get(1);
    }

    private static boolean isValidDataNode(String dataNodeStr) {
        return dataNodeStr.contains(DELIMITER) && 2 == Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNodeStr).size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || this.getClass() != object.getClass()) {
            return false;
        }
        DataNode dataNode = (DataNode)object;
        return Objects.equal((Object)this.dataSourceName.toUpperCase(), (Object)dataNode.dataSourceName.toUpperCase()) && Objects.equal((Object)this.tableName.toUpperCase(), (Object)dataNode.tableName.toUpperCase());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataSourceName.toUpperCase(), this.tableName.toUpperCase()});
    }

    @ConstructorProperties(value={"dataSourceName", "tableName"})
    public DataNode(String dataSourceName, String tableName) {
        this.dataSourceName = dataSourceName;
        this.tableName = tableName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return "DataNode(dataSourceName=" + this.getDataSourceName() + ", tableName=" + this.getTableName() + ")";
    }
}

