/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.J2Cache;
import net.oschina.j2cache.NullCacheProvider;
import net.oschina.j2cache.ehcache.EhCacheProvider;
import net.oschina.j2cache.redis.RedisCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManager {
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private static CacheProvider l1_provider;
    private static CacheProvider l2_provider;
    private static CacheExpiredListener listener;
    private static String serializer;

    public static void initCacheProvider(CacheExpiredListener listener) {
        CacheManager.listener = listener;
        try {
            Properties props = J2Cache.loadConfig();
            l1_provider = CacheManager.getProviderInstance(props.getProperty("cache.L1.provider_class"));
            l1_provider.start(CacheManager.getProviderProperties(props, l1_provider));
            log.info("Using L1 CacheProvider : " + l1_provider.getClass().getName());
            l2_provider = CacheManager.getProviderInstance(props.getProperty("cache.L2.provider_class"));
            l2_provider.start(CacheManager.getProviderProperties(props, l2_provider));
            log.info("Using L2 CacheProvider : " + l2_provider.getClass().getName());
            serializer = props.getProperty("cache.serialization");
        }
        catch (Exception e) {
            throw new CacheException("Unabled to initialize cache providers", e);
        }
    }

    public static final String getSerializer() {
        return serializer;
    }

    private static final CacheProvider getProviderInstance(String value) throws Exception {
        if ("ehcache".equalsIgnoreCase(value)) {
            return new EhCacheProvider();
        }
        if ("redis".equalsIgnoreCase(value)) {
            return new RedisCacheProvider();
        }
        if ("none".equalsIgnoreCase(value)) {
            return new NullCacheProvider();
        }
        return (CacheProvider)Class.forName(value).newInstance();
    }

    private static final Properties getProviderProperties(Properties props, CacheProvider provider) {
        Properties new_props = new Properties();
        Enumeration<Object> keys = props.keys();
        String prefix = provider.name() + '.';
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            new_props.setProperty(key.substring(prefix.length()), props.getProperty(key));
        }
        return new_props;
    }

    private static final Cache _GetCache(int level, String cache_name, boolean autoCreate) {
        return (level == 1 ? l1_provider : l2_provider).buildCache(cache_name, autoCreate, listener);
    }

    public static final void shutdown(int level) {
        (level == 1 ? l1_provider : l2_provider).stop();
    }

    public static final Object get(int level, String name, Object key) {
        Cache cache;
        if (name != null && key != null && (cache = CacheManager._GetCache(level, name, false)) != null) {
            return cache.get(key);
        }
        return null;
    }

    public static final <T> T get(int level, Class<T> resultClass, String name, Object key) {
        Cache cache;
        if (name != null && key != null && (cache = CacheManager._GetCache(level, name, false)) != null) {
            return (T)cache.get(key);
        }
        return null;
    }

    public static final void set(int level, String name, Object key, Object value) {
        Cache cache;
        if (name != null && key != null && value != null && (cache = CacheManager._GetCache(level, name, true)) != null) {
            cache.put(key, value);
        }
    }

    public static final void evict(int level, String name, Object key) {
        Cache cache;
        if (name != null && key != null && (cache = CacheManager._GetCache(level, name, false)) != null) {
            cache.evict(key);
        }
    }

    public static final void batchEvict(int level, String name, List keys) {
        Cache cache;
        if (name != null && keys != null && keys.size() > 0 && (cache = CacheManager._GetCache(level, name, false)) != null) {
            cache.evict(keys);
        }
    }

    public static final void clear(int level, String name) throws CacheException {
        Cache cache = CacheManager._GetCache(level, name, false);
        if (cache != null) {
            cache.clear();
        }
    }

    public static final List keys(int level, String name) throws CacheException {
        Cache cache = CacheManager._GetCache(level, name, false);
        return cache != null ? cache.keys() : null;
    }
}

