/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.io.IOException;
import net.oschina.j2cache.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger log = LoggerFactory.getLogger(Command.class);
    public static final byte OPT_DELETE_KEY = 1;
    public static final byte OPT_CLEAR_KEY = 2;
    private byte operator;
    private String region;
    private Object key;

    public static void main(String[] args) {
        byte[] bufs;
        Command cmd = new Command(1, "users", "ld");
        for (byte b : bufs = cmd.toBuffers()) {
            System.out.printf("[%s]", Integer.toHexString(b));
        }
        System.out.println();
        Command cmd2 = Command.parse(bufs);
        System.out.printf("%d:%s:%s\n", cmd2.getOperator(), cmd2.getRegion(), cmd2.getKey());
    }

    public Command(byte o, String r, Object k) {
        this.operator = o;
        this.region = r;
        this.key = k;
    }

    public byte[] toBuffers() {
        byte[] keyBuffers = null;
        try {
            keyBuffers = SerializationUtils.serialize(this.key);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int r_len = this.region.getBytes().length;
        int k_len = keyBuffers.length;
        byte[] buffers = new byte[5 + r_len + k_len];
        int idx = 0;
        buffers[idx] = this.operator;
        buffers[++idx] = (byte)(r_len >> 8);
        buffers[++idx] = (byte)(r_len & 0xFF);
        System.arraycopy(this.region.getBytes(), 0, buffers, ++idx, r_len);
        idx += r_len;
        buffers[idx++] = (byte)(k_len >> 8);
        buffers[idx++] = (byte)(k_len & 0xFF);
        System.arraycopy(keyBuffers, 0, buffers, idx, k_len);
        return buffers;
    }

    public static Command parse(byte[] buffers) {
        Command cmd = null;
        try {
            int idx = 0;
            byte opt = buffers[idx];
            int r_len = buffers[++idx] << 8;
            if ((r_len += buffers[++idx]) > 0) {
                String region = new String(buffers, ++idx, r_len);
                idx += r_len;
                int k_len = buffers[idx++] << 8;
                if ((k_len += buffers[idx++]) > 0) {
                    byte[] keyBuffers = new byte[k_len];
                    System.arraycopy(buffers, idx, keyBuffers, 0, k_len);
                    Object key = SerializationUtils.deserialize(keyBuffers);
                    cmd = new Command(opt, region, key);
                }
            }
        }
        catch (Exception e) {
            log.error("Unabled to parse received command.", (Throwable)e);
        }
        return cmd;
    }

    public byte getOperator() {
        return this.operator;
    }

    public void setOperator(byte operator) {
        this.operator = operator;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }
}

