/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheManager;
import net.oschina.j2cache.JGroupsCacheChannel;
import net.oschina.j2cache.RedisCacheChannel;

public class J2Cache {
    private static final String CONFIG_FILE = "/j2cache.properties";
    private static final CacheChannel channel;

    public static CacheChannel getChannel() {
        return channel;
    }

    static Properties loadConfig() throws IOException {
        InputStream configStream = J2Cache.class.getClassLoader().getParent().getResourceAsStream(CONFIG_FILE);
        if (configStream == null) {
            configStream = CacheManager.class.getResourceAsStream(CONFIG_FILE);
        }
        if (configStream == null) {
            throw new CacheException("Cannot find /j2cache.properties !!!");
        }
        Properties props = new Properties();
        try {
            props.load(configStream);
        }
        finally {
            configStream.close();
        }
        return props;
    }

    static {
        block4: {
            try {
                Properties props = J2Cache.loadConfig();
                String cache_broadcast = props.getProperty("cache.broadcast");
                if ("redis".equalsIgnoreCase(cache_broadcast)) {
                    channel = RedisCacheChannel.getInstance();
                    break block4;
                }
                if ("jgroups".equalsIgnoreCase(cache_broadcast)) {
                    channel = JGroupsCacheChannel.getInstance();
                    break block4;
                }
                throw new CacheException("Cache Channel not defined. name = " + cache_broadcast);
            }
            catch (IOException e) {
                throw new CacheException("Unabled to load j2cache configuration /j2cache.properties", e);
            }
        }
    }
}

