/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.net.URL;
import java.util.List;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheManager;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.Command;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsCacheChannel
extends ReceiverAdapter
implements CacheExpiredListener,
CacheChannel {
    private static final Logger log = LoggerFactory.getLogger(JGroupsCacheChannel.class);
    private static final String CONFIG_XML = "/network.xml";
    public static final byte LEVEL_1 = 1;
    public static final byte LEVEL_2 = 2;
    private String name;
    private JChannel channel;
    private static final JGroupsCacheChannel instance = new JGroupsCacheChannel("default");

    public static final JGroupsCacheChannel getInstance() {
        return instance;
    }

    private JGroupsCacheChannel(String name) throws CacheException {
        this.name = name;
        try {
            CacheManager.initCacheProvider(this);
            long ct = System.currentTimeMillis();
            URL xml = CacheChannel.class.getResource(CONFIG_XML);
            if (xml == null) {
                xml = this.getClass().getClassLoader().getParent().getResource(CONFIG_XML);
            }
            this.channel = new JChannel(xml);
            this.channel.setReceiver((Receiver)this);
            this.channel.connect(this.name);
            log.info("Connected to channel:" + this.name + ", time " + (System.currentTimeMillis() - ct) + " ms.");
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public CacheObject get(String region, Object key) {
        CacheObject obj = new CacheObject();
        obj.setRegion(region);
        obj.setKey(key);
        if (region != null && key != null) {
            obj.setValue(CacheManager.get(1, region, key));
            if (obj.getValue() == null) {
                obj.setValue(CacheManager.get(2, region, key));
                if (obj.getValue() != null) {
                    obj.setLevel((byte)2);
                    CacheManager.set(1, region, key, obj.getValue());
                }
            } else {
                obj.setLevel((byte)1);
            }
        }
        return obj;
    }

    @Override
    public void set(String region, Object key, Object value) {
        if (region != null && key != null) {
            if (value == null) {
                this.evict(region, key);
            } else {
                this._sendEvictCmd(region, key);
                CacheManager.set(1, region, key, value);
                CacheManager.set(2, region, key, value);
            }
        }
    }

    @Override
    public void evict(String region, Object key) {
        CacheManager.evict(1, region, key);
        CacheManager.evict(2, region, key);
        this._sendEvictCmd(region, key);
    }

    @Override
    public void batchEvict(String region, List keys) {
        CacheManager.batchEvict(1, region, keys);
        CacheManager.batchEvict(2, region, keys);
        this._sendEvictCmd(region, keys);
    }

    @Override
    public void clear(String region) throws CacheException {
        CacheManager.clear(1, region);
        CacheManager.clear(2, region);
        this._sendClearCmd(region);
    }

    @Override
    public List keys(String region) throws CacheException {
        return CacheManager.keys(1, region);
    }

    @Override
    public void notifyElementExpired(String region, Object key) {
        log.debug("Cache data expired, region=" + region + ",key=" + key);
        if (key instanceof List) {
            CacheManager.batchEvict(2, region, (List)key);
        } else {
            CacheManager.evict(2, region, key);
        }
        this._sendEvictCmd(region, key);
    }

    private void _sendEvictCmd(String region, Object key) {
        Command cmd = new Command(1, region, key);
        try {
            Message msg = new Message(null, null, cmd.toBuffers());
            this.channel.send(msg);
        }
        catch (Exception e) {
            log.error("Unable to delete cache,region=" + region + ",key=" + key, (Throwable)e);
        }
    }

    private void _sendClearCmd(String region) {
        Command cmd = new Command(2, region, "");
        try {
            Message msg = new Message(null, null, cmd.toBuffers());
            this.channel.send(msg);
        }
        catch (Exception e) {
            log.error("Unable to clear cache,region=" + region, (Throwable)e);
        }
    }

    protected void onDeleteCacheKey(String region, Object key) {
        if (key instanceof List) {
            CacheManager.batchEvict(1, region, (List)key);
        } else {
            CacheManager.evict(1, region, key);
        }
        log.debug("Received cache evict message, region=" + region + ",key=" + key);
    }

    protected void onClearCacheKey(String region) {
        CacheManager.clear(1, region);
        log.debug("Received cache clear message, region=" + region);
    }

    public void receive(Message msg) {
        byte[] buffers = msg.getBuffer();
        if (buffers.length < 1) {
            log.warn("Message is empty.");
            return;
        }
        if (msg.getSrc().equals(this.channel.getAddress())) {
            return;
        }
        try {
            Command cmd = Command.parse(buffers);
            if (cmd == null) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    this.onDeleteCacheKey(cmd.getRegion(), cmd.getKey());
                    break;
                }
                case 2: {
                    this.onClearCacheKey(cmd.getRegion());
                    break;
                }
                default: {
                    log.warn("Unknown message type = " + cmd.getOperator());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to handle received msg", (Throwable)e);
        }
    }

    public void viewAccepted(View view) {
        StringBuffer sb = new StringBuffer("Group Members Changed, LIST: ");
        List addrs = view.getMembers();
        for (int i = 0; i < addrs.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(((Address)addrs.get(i)).toString());
        }
        log.info(sb.toString());
    }

    @Override
    public void close() {
        CacheManager.shutdown(1);
        CacheManager.shutdown(2);
        this.channel.close();
    }
}

