/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.ehcache;

import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.ehcache.EhCache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(EhCacheProvider.class);
    private static final String CONFIG_XML = "/ehcache.xml";
    private CacheManager manager;
    private ConcurrentHashMap<String, EhCache> _CacheManager;

    @Override
    public String name() {
        return "ehcache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EhCache buildCache(String name, boolean autoCreate, CacheExpiredListener listener) throws CacheException {
        EhCache ehcache = this._CacheManager.get(name);
        if (ehcache == null && autoCreate) {
            try {
                ConcurrentHashMap<String, EhCache> concurrentHashMap = this._CacheManager;
                synchronized (concurrentHashMap) {
                    ehcache = this._CacheManager.get(name);
                    if (ehcache == null) {
                        Cache cache = this.manager.getCache(name);
                        if (cache == null) {
                            log.warn("Could not find configuration [" + name + "]; using defaults.");
                            this.manager.addCache(name);
                            cache = this.manager.getCache(name);
                            log.debug("started EHCache region: " + name);
                        }
                        ehcache = new EhCache(cache, listener);
                        this._CacheManager.put(name, ehcache);
                    }
                }
            }
            catch (net.sf.ehcache.CacheException e) {
                throw new CacheException(e);
            }
        }
        return ehcache;
    }

    @Override
    public void start(Properties props) throws CacheException {
        if (this.manager != null) {
            log.warn("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Using previously created EhCacheProvider. If this behaviour is required, consider using net.sf.ehcache.hibernate.SingletonEhCacheProvider.");
            return;
        }
        URL xml = this.getClass().getClassLoader().getParent().getResource(CONFIG_XML);
        if (xml == null) {
            xml = this.getClass().getResource(CONFIG_XML);
        }
        if (xml == null) {
            throw new CacheException("cannot find ehcache.xml !!!");
        }
        this.manager = new CacheManager();
        this._CacheManager = new ConcurrentHashMap();
    }

    @Override
    public void stop() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
        }
    }
}

