/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.util.Properties;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.redis.RedisCache;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCacheProvider
implements CacheProvider {
    private static String host;
    private static int port;
    private static int timeout;
    private static String password;
    private static int database;
    private static JedisPool pool;

    @Override
    public String name() {
        return "redis";
    }

    public static void returnResource(Jedis jedis, boolean isBrokenResource) {
        if (null == jedis) {
            return;
        }
        if (isBrokenResource) {
            jedis.close();
            jedis = null;
        } else {
            pool.returnResourceObject((Object)jedis);
        }
    }

    public static Jedis getResource() {
        return pool.getResource();
    }

    @Override
    public Cache buildCache(String regionName, boolean autoCreate, CacheExpiredListener listener) throws CacheException {
        return new RedisCache(regionName);
    }

    @Override
    public void start(Properties props) throws CacheException {
        JedisPoolConfig config = new JedisPoolConfig();
        host = RedisCacheProvider.getProperty(props, "host", "127.0.0.1");
        password = props.getProperty("password", null);
        port = RedisCacheProvider.getProperty(props, "port", 6379);
        timeout = RedisCacheProvider.getProperty(props, "timeout", 2000);
        database = RedisCacheProvider.getProperty(props, "database", 0);
        config.setBlockWhenExhausted(RedisCacheProvider.getProperty(props, "blockWhenExhausted", true));
        config.setMaxIdle(RedisCacheProvider.getProperty(props, "maxIdle", 10));
        config.setMinIdle(RedisCacheProvider.getProperty(props, "minIdle", 5));
        config.setMaxWaitMillis((long)RedisCacheProvider.getProperty(props, "maxWait", 100));
        config.setTestWhileIdle(RedisCacheProvider.getProperty(props, "testWhileIdle", false));
        config.setTestOnBorrow(RedisCacheProvider.getProperty(props, "testOnBorrow", true));
        config.setTestOnReturn(RedisCacheProvider.getProperty(props, "testOnReturn", false));
        config.setNumTestsPerEvictionRun(RedisCacheProvider.getProperty(props, "numTestsPerEvictionRun", 10));
        config.setMinEvictableIdleTimeMillis((long)RedisCacheProvider.getProperty(props, "minEvictableIdleTimeMillis", 1000));
        config.setSoftMinEvictableIdleTimeMillis((long)RedisCacheProvider.getProperty(props, "softMinEvictableIdleTimeMillis", 10));
        config.setTimeBetweenEvictionRunsMillis((long)RedisCacheProvider.getProperty(props, "timeBetweenEvictionRunsMillis", 10));
        config.setLifo(RedisCacheProvider.getProperty(props, "lifo", false));
        pool = new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password, database);
    }

    @Override
    public void stop() {
        pool.destroy();
    }

    private static String getProperty(Properties props, String key, String defaultValue) {
        return props.getProperty(key, defaultValue).trim();
    }

    private static int getProperty(Properties props, String key, int defaultValue) {
        try {
            return Integer.parseInt(props.getProperty(key, String.valueOf(defaultValue)).trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static boolean getProperty(Properties props, String key, boolean defaultValue) {
        return "true".equalsIgnoreCase(props.getProperty(key, String.valueOf(defaultValue)).trim());
    }
}

