/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.oschina.j2cache.util.Serializer;
import net.sf.ehcache.CacheException;

public class FSTSerializer
implements Serializer {
    @Override
    public String name() {
        return "fst";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = null;
        FSTObjectOutput fout = null;
        try {
            out = new ByteArrayOutputStream();
            fout = new FSTObjectOutput((OutputStream)out);
            fout.writeObject(obj);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        FSTObjectInput in = null;
        try {
            in = new FSTObjectInput((InputStream)new ByteArrayInputStream(bytes));
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

