/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j;

import org.fax4j.FaxClientActionEventListener;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxJobStatus;
import org.fax4j.FaxMonitorEventListener;
import org.fax4j.Provider;
import org.fax4j.common.FaxClientActions;
import org.fax4j.common.Logger;
import org.fax4j.spi.FaxClientSpi;

public class FaxClient
implements FaxClientActions {
    private final FaxClientSpi FAX_CLIENT_SPI;

    public FaxClient(FaxClientSpi faxClientSpi) {
        this.FAX_CLIENT_SPI = faxClientSpi;
        if (this.FAX_CLIENT_SPI == null) {
            throw new FaxException("Fax client SPI is null.");
        }
        Logger logger = this.FAX_CLIENT_SPI.getLogger();
        if (logger == null) {
            throw new FaxException("Fax client logger is null.");
        }
    }

    protected final FaxClientSpi getFaxClientSpi() {
        return this.FAX_CLIENT_SPI;
    }

    public final Provider getProvider() {
        return this.FAX_CLIENT_SPI.getProvider();
    }

    public FaxJob createFaxJob() {
        return this.FAX_CLIENT_SPI.createFaxJob();
    }

    public void submitFaxJob(FaxJob faxJob) {
        this.FAX_CLIENT_SPI.submitFaxJob(faxJob);
    }

    public void suspendFaxJob(FaxJob faxJob) {
        this.FAX_CLIENT_SPI.suspendFaxJob(faxJob);
    }

    public void resumeFaxJob(FaxJob faxJob) {
        this.FAX_CLIENT_SPI.resumeFaxJob(faxJob);
    }

    public void cancelFaxJob(FaxJob faxJob) {
        this.FAX_CLIENT_SPI.cancelFaxJob(faxJob);
    }

    public FaxJobStatus getFaxJobStatus(FaxJob faxJob) {
        return this.FAX_CLIENT_SPI.getFaxJobStatus(faxJob);
    }

    public void addFaxClientActionEventListener(FaxClientActionEventListener listener) {
        this.FAX_CLIENT_SPI.addFaxClientActionEventListener(listener);
    }

    public void removeFaxClientActionEventListener(FaxClientActionEventListener listener) {
        this.FAX_CLIENT_SPI.removeFaxClientActionEventListener(listener);
    }

    public void removeAllFaxClientActionEventListeners() {
        this.FAX_CLIENT_SPI.removeAllFaxClientActionEventListeners();
    }

    public void addFaxMonitorEventListener(FaxMonitorEventListener listener) {
        this.FAX_CLIENT_SPI.addFaxMonitorEventListener(listener);
    }

    public void removeFaxMonitorEventListener(FaxMonitorEventListener listener) {
        this.FAX_CLIENT_SPI.removeFaxMonitorEventListener(listener);
    }

    public void removeAllFaxMonitorEventListeners() {
        this.FAX_CLIENT_SPI.removeAllFaxMonitorEventListeners();
    }
}

