/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.fax4j.FaxClient;
import org.fax4j.FaxException;
import org.fax4j.spi.FaxClientSpi;
import org.fax4j.spi.FaxClientSpiFactory;
import org.fax4j.util.ReflectionHelper;

public final class FaxClientFactory {
    public static final String FAX_CLIENT_CLASS_NAME_PROPERTY_KEY = "org.fax4j.client.class.name";

    private FaxClientFactory() {
    }

    public static FaxClient createFaxClient() {
        return FaxClientFactory.createFaxClient(null, null);
    }

    public static FaxClient createFaxClient(String type, Properties configuration) {
        return FaxClientFactory.createFaxClientImpl(type, configuration);
    }

    private static FaxClient createFaxClientImpl(String type, Properties configuration) {
        FaxClientSpi faxClientSpi = FaxClientSpiFactory.createFaxClientSpi(type, configuration);
        String className = faxClientSpi.getConfigurationValue(FAX_CLIENT_CLASS_NAME_PROPERTY_KEY);
        if (className == null || className.length() == 0) {
            className = FaxClient.class.getName();
        }
        Class<?> classDefinition = ReflectionHelper.getType(className);
        FaxClient faxClient = null;
        try {
            Constructor<?> constructor = classDefinition.getConstructor(FaxClientSpi.class);
            faxClient = (FaxClient)constructor.newInstance(faxClientSpi);
        }
        catch (Exception exception) {
            throw new FaxException("Unable to create a new fax client instance for class name: " + className, exception);
        }
        return faxClient;
    }
}

