/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge;

import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.bridge.ContextFaxBridge;
import org.fax4j.bridge.FaxBridgeImpl;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.RequestParser;
import org.fax4j.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextFaxBridge<T>
extends FaxBridgeImpl
implements ContextFaxBridge<T> {
    private RequestParser<T> requestParser;

    @Override
    protected void initializeImpl() {
        this.requestParser = this.createRequestParser();
        if (this.requestParser == null) {
            throw new FaxException("Unable to create request parser.");
        }
    }

    @Override
    public FaxJob submitFaxJob(T inputData) {
        if (inputData == null) {
            throw new FaxException("Input data not provided.");
        }
        FaxJob faxJob = this.createFaxJob();
        this.requestParser.updateFaxJobFromInputData(inputData, faxJob);
        FileInfo fileInfo = this.requestParser.getFileInfoFromInputData(inputData);
        if (fileInfo == null) {
            throw new FaxException("Unable to extract file info from input data.");
        }
        this.submitFaxJob(faxJob, fileInfo);
        return faxJob;
    }

    protected RequestParser<T> createRequestParser() {
        String configurationKey = this.getRequestParserConfigurationKey();
        String defaultParserClassName = this.getDefaultParserClassName();
        RequestParser<T> parser = this.createRequestParser(configurationKey, defaultParserClassName);
        return parser;
    }

    protected RequestParser<T> createRequestParser(String configurationKey, String defaultParserClassName) {
        if (configurationKey == null) {
            throw new FaxException("Configuration key for request parser not provided.");
        }
        String className = this.getConfigurationValue(configurationKey);
        if (className == null && (className = defaultParserClassName) == null) {
            throw new FaxException("Request parser class name not found.");
        }
        RequestParser parser = (RequestParser)ReflectionHelper.createInstance(className);
        Map<String, String> configuration = this.getConfiguration();
        parser.initialize(configuration);
        return parser;
    }

    protected abstract String getRequestParserConfigurationKey();

    protected abstract String getDefaultParserClassName();
}

