/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fax4j.FaxClient;
import org.fax4j.FaxClientFactory;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.FaxMonitorEventListener;
import org.fax4j.bridge.FaxBridge;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.VendorPolicy;
import org.fax4j.common.ConfigurationHolder;
import org.fax4j.common.ConfigurationHolderImpl;
import org.fax4j.common.Logger;
import org.fax4j.common.LoggerManager;
import org.fax4j.util.SpiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaxBridge
implements FaxBridge {
    private boolean initialized = false;
    private ConfigurationHolder bridgeConfiguration;
    private Logger bridgeLogger;
    private FaxClient faxClient;
    private VendorPolicy vendorPolicy;

    @Override
    public final synchronized void initialize(String type, Properties configuration, Object flowOwner) {
        if (this.initialized) {
            throw new FaxException("Fax bridge already initialized.");
        }
        this.initialized = true;
        HashMap<String, String> map = new HashMap<String, String>();
        SpiUtil.copyPropertiesToMap(configuration, map);
        this.bridgeConfiguration = new ConfigurationHolderImpl(map);
        this.faxClient = FaxClientFactory.createFaxClient(type, configuration);
        LoggerManager loggerManager = LoggerManager.getInstance();
        this.bridgeLogger = loggerManager.getLogger();
        this.vendorPolicy = this.createVendorPolicy();
        if (this.vendorPolicy == null) {
            throw new FaxException("Unable to create vendor policy");
        }
        this.vendorPolicy.initialize(flowOwner);
        if (this.vendorPolicy instanceof FaxMonitorEventListener) {
            this.faxClient.addFaxMonitorEventListener((FaxMonitorEventListener)((Object)this.vendorPolicy));
        }
        this.bridgeLogger.logDebug(new Object[]{"Initializing fax bridge of type: ", this.getClass().getName(), "\nProvider Information:\n", this.getProvider(), "\nFax Bridge Configuration:\n", configuration, "\nVendor Policy Type: ", this.vendorPolicy.getClass().getName()}, null);
        this.initializeImpl();
    }

    @Override
    public final Logger getLogger() {
        return this.bridgeLogger;
    }

    @Override
    public String getPropertyPart() {
        return null;
    }

    @Override
    public final Map<String, String> getConfiguration() {
        return this.bridgeConfiguration.getConfiguration();
    }

    @Override
    public final String getConfigurationValue(String key) {
        String value = this.bridgeConfiguration.getConfigurationValue(key);
        return value;
    }

    @Override
    public final String getConfigurationValue(Enum<?> key) {
        String value = this.bridgeConfiguration.getConfigurationValue(key);
        return value;
    }

    @Override
    public final FaxClient getFaxClient() {
        return this.faxClient;
    }

    @Override
    public final VendorPolicy getVendorPolicy() {
        return this.vendorPolicy;
    }

    @Override
    public FaxJob createFaxJob() {
        if (!this.initialized) {
            throw new FaxException("Fax bridge not initialized.");
        }
        FaxJob faxJob = this.faxClient.createFaxJob();
        return faxJob;
    }

    @Override
    public void submitFaxJob(FaxJob faxJob, FileInfo fileInfo) {
        if (!this.initialized) {
            throw new FaxException("Fax bridge not initialized.");
        }
        if (faxJob == null) {
            throw new FaxException("File job not provided.");
        }
        if (fileInfo == null) {
            throw new FaxException("File info not provided.");
        }
        this.updateFaxJobWithFileInfo(faxJob, fileInfo);
        this.faxClient.submitFaxJob(faxJob);
    }

    protected void initializeImpl() {
    }

    protected abstract VendorPolicy createVendorPolicy();

    protected abstract void updateFaxJobWithFileInfo(FaxJob var1, FileInfo var2);
}

