/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge;

import java.util.Map;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.RequestParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestParser<T>
implements RequestParser<T> {
    private boolean initialized = false;

    @Override
    public final synchronized void initialize(Map<String, String> configuration) {
        if (this.initialized) {
            throw new FaxException("Request parser already initialized.");
        }
        this.initialized = true;
        this.initializeImpl(configuration);
    }

    @Override
    public FileInfo getFileInfoFromInputData(T inputData) {
        if (!this.initialized) {
            throw new FaxException("Fax bridge not initialized.");
        }
        FileInfo fileInfo = this.getFileInfoFromInputDataImpl(inputData);
        return fileInfo;
    }

    @Override
    public void updateFaxJobFromInputData(T inputData, FaxJob faxJob) {
        if (!this.initialized) {
            throw new FaxException("Fax bridge not initialized.");
        }
        this.updateFaxJobFromInputDataImpl(inputData, faxJob);
    }

    protected abstract void initializeImpl(Map<String, String> var1);

    protected abstract FileInfo getFileInfoFromInputDataImpl(T var1);

    protected abstract void updateFaxJobFromInputDataImpl(T var1, FaxJob var2);
}

