/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge;

import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.Provider;
import org.fax4j.bridge.VendorPolicy;

public abstract class AbstractVendorPolicy
implements VendorPolicy {
    private boolean initialized;
    private Object vendorPolicyFlowOwner;
    private final Provider PROVIDER;

    protected AbstractVendorPolicy(Provider provider) {
        if (provider == null) {
            throw new FaxException("Provider object is null.");
        }
        this.PROVIDER = provider;
        this.initialized = false;
    }

    public final Provider getProvider() {
        return this.PROVIDER;
    }

    protected Object getFlowOwner() {
        return this.vendorPolicyFlowOwner;
    }

    public final synchronized void initialize(Object flowOwner) {
        if (this.initialized) {
            throw new FaxException("Vendor policy already initialized.");
        }
        if (flowOwner == null) {
            throw new FaxException("Flow owner not provided.");
        }
        this.initialized = true;
        this.vendorPolicyFlowOwner = flowOwner;
        this.initializeImpl();
    }

    public boolean invokePolicyForRequest(Object requestDataHolder) {
        if (requestDataHolder == null) {
            throw new FaxException("Request data holder not provided.");
        }
        boolean continueFlow = this.invokePolicyForRequestImpl(requestDataHolder);
        return continueFlow;
    }

    public boolean invokePolicyForResponse(Object requestDataHolder, FaxJob faxJob) {
        if (requestDataHolder == null) {
            throw new FaxException("Request data holder not provided.");
        }
        if (faxJob == null) {
            throw new FaxException("Fax job not provided.");
        }
        boolean continueFlow = this.invokePolicyForResponseImpl(requestDataHolder, faxJob);
        return continueFlow;
    }

    protected abstract void initializeImpl();

    protected abstract boolean invokePolicyForRequestImpl(Object var1);

    protected abstract boolean invokePolicyForResponseImpl(Object var1, FaxJob var2);
}

