/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge;

import java.util.Properties;
import org.fax4j.FaxJob;
import org.fax4j.bridge.ContextFaxBridge;
import org.fax4j.bridge.VendorPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaxBridgeFlowHelper<T> {
    private final ContextFaxBridge<T> FAX_BRIDGE;

    public FaxBridgeFlowHelper(ContextFaxBridge<T> faxBridge, String type, Properties configuration, Object flowOwner) {
        this.FAX_BRIDGE = faxBridge;
        this.FAX_BRIDGE.initialize(type, configuration, flowOwner);
    }

    public ContextFaxBridge<T> getFaxBridge() {
        return this.FAX_BRIDGE;
    }

    public FlowResponse submitFaxJob(T inputData, Object contextData, boolean invokeVendorPolicy) {
        boolean continueFlow = true;
        VendorPolicy vendorPolicy = null;
        if (invokeVendorPolicy) {
            vendorPolicy = this.FAX_BRIDGE.getVendorPolicy();
            continueFlow = vendorPolicy.invokePolicyForRequest(contextData);
        }
        FaxJob faxJob = null;
        if (continueFlow) {
            faxJob = this.FAX_BRIDGE.submitFaxJob(inputData);
            if (invokeVendorPolicy) {
                continueFlow = vendorPolicy.invokePolicyForResponse(contextData, faxJob);
            }
        }
        FlowResponse flowResponse = new FlowResponse(faxJob, continueFlow);
        return flowResponse;
    }

    public static class FlowResponse {
        private final FaxJob FAX_JOB;
        private final boolean CONTINUE_FLOW;

        public FlowResponse(FaxJob faxJob, boolean continueFlow) {
            this.FAX_JOB = faxJob;
            this.CONTINUE_FLOW = continueFlow;
        }

        public FaxJob getFaxJob() {
            return this.FAX_JOB;
        }

        public boolean isContinueFlow() {
            return this.CONTINUE_FLOW;
        }
    }
}

