/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge;

import java.io.File;
import java.io.IOException;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.bridge.AbstractFax4JBridge;
import org.fax4j.bridge.EmptyVendorPolicy;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.VendorPolicy;
import org.fax4j.common.Logger;
import org.fax4j.util.IOHelper;
import org.fax4j.util.ReflectionHelper;

public class FaxBridgeImpl
extends AbstractFax4JBridge {
    protected VendorPolicy createVendorPolicy() {
        String className = this.getConfigurationValue("org.fax4j.bridge.vendor.policy.class.name");
        if (className == null) {
            className = EmptyVendorPolicy.class.getName();
        }
        VendorPolicy vendorPolicy = (VendorPolicy)ReflectionHelper.createInstance(className);
        Logger logger = this.getLogger();
        logger.logInfo(new Object[]{"Created new vendor policy of type: ", className}, null);
        return vendorPolicy;
    }

    protected void updateFaxJobWithFileInfo(FaxJob faxJob, FileInfo fileInfo) {
        File file = fileInfo.getFile();
        if (file == null) {
            String fileName = fileInfo.getName();
            byte[] content = fileInfo.getContent();
            try {
                file = File.createTempFile("fax_", fileName);
                IOHelper.writeFile(content, file);
            }
            catch (IOException exception) {
                throw new FaxException("Unable to write file content to temporary file.", exception);
            }
        }
        faxJob.setFile(file);
    }
}

