/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge;

import java.io.File;
import org.fax4j.FaxException;

public class FileInfo {
    private final File FILE;
    private final String NAME;
    private final byte[] CONTENT;

    private FileInfo(File file, String name, byte[] content) {
        if (file == null) {
            if (name == null || name.length() == 0) {
                throw new FaxException("File name not provided.");
            }
            if (content == null || content.length == 0) {
                throw new FaxException("File content not provided.");
            }
            this.FILE = null;
            this.NAME = name.trim();
            this.CONTENT = (byte[])content.clone();
        } else {
            this.FILE = file;
            this.NAME = this.FILE.getName();
            this.CONTENT = null;
        }
        if (this.NAME.length() == 0) {
            throw new FaxException("File name not provided.");
        }
    }

    public FileInfo(File file) {
        this(file, null, null);
    }

    public FileInfo(String name, byte[] content) {
        this(null, name, content);
    }

    public final File getFile() {
        return this.FILE;
    }

    public final String getName() {
        return this.NAME;
    }

    public final byte[] getContent() {
        byte[] content = (byte[])this.CONTENT.clone();
        return content;
    }
}

