/*
 * Decompiled with CFR 0.152.
 */
package org.fax4j.bridge.email;

import java.io.IOException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.fax4j.FaxException;
import org.fax4j.FaxJob;
import org.fax4j.bridge.AbstractRequestParser;
import org.fax4j.bridge.FileInfo;
import org.fax4j.bridge.email.MailMessageParser;
import org.fax4j.util.IOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMailMessageParser
extends AbstractRequestParser<Message>
implements MailMessageParser {
    @Override
    protected void initializeImpl(Map<String, String> configuration) {
    }

    @Override
    protected FileInfo getFileInfoFromInputDataImpl(Message inputData) {
        FileInfo fileInfo = null;
        try {
            fileInfo = this.getFileInfo(inputData);
        }
        catch (MessagingException exception) {
            throw new FaxException("Unable to extract fax job file data from mail message.", exception);
        }
        catch (IOException exception) {
            throw new FaxException("Unable to extract fax job file data from mail message.", exception);
        }
        return fileInfo;
    }

    @Override
    protected void updateFaxJobFromInputDataImpl(Message inputData, FaxJob faxJob) {
        String targetAddress = null;
        String senderEmail = null;
        try {
            targetAddress = this.getTargetAddress(inputData);
            senderEmail = this.getSenderEmail(inputData);
        }
        catch (MessagingException exception) {
            throw new FaxException("Unable to extract fax job data from mail message.", exception);
        }
        faxJob.setTargetAddress(targetAddress);
        faxJob.setSenderEmail(senderEmail);
    }

    protected String getTargetAddress(Message mailMessage) throws MessagingException {
        String subject = mailMessage.getSubject();
        String targetAddress = null;
        if (subject != null && subject.startsWith("fax:") && subject.length() > 4) {
            targetAddress = subject.substring(4);
        }
        return targetAddress;
    }

    protected String getSenderEmail(Message mailMessage) throws MessagingException {
        Address[] addresses = mailMessage.getFrom();
        String senderEmail = null;
        if (addresses != null && addresses.length > 0) {
            Address address = addresses[0];
            senderEmail = address.toString();
        }
        return senderEmail;
    }

    protected FileInfo getFileInfo(Message mailMessage) throws MessagingException, IOException {
        Object messageContent = mailMessage.getContent();
        String charset = null;
        if (mailMessage instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)mailMessage;
            charset = mimeMessage.getEncoding();
        }
        String name = "fax.txt";
        byte[] content = null;
        if (messageContent instanceof String) {
            content = IOHelper.convertStringToBinary((String)messageContent, charset);
        } else if (messageContent instanceof Multipart) {
            Multipart multiPart = (Multipart)messageContent;
            int amount = multiPart.getCount();
            BodyPart part = null;
            DataHandler dataHandler = null;
            if (amount > 0) {
                part = multiPart.getBodyPart(0);
                dataHandler = part.getDataHandler();
                name = dataHandler.getName();
                if (name == null) {
                    name = "fax.txt";
                }
                content = IOHelper.readStream(part.getInputStream());
            }
        }
        FileInfo fileInfo = new FileInfo(name, content);
        return fileInfo;
    }
}

